<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'employee-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
$model_general_setting = HrGenerelSettings::model()->find();
$model_module_leave = HrModules::model()->findByPK(3);
$model_module_payroll = HrModules::model()->findByPK(7);
$model_module_employee = HrModules::model()->findByPK(1);
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php
                if ($model_general_setting->auto_increment_employee_code == 'Y') {
                    echo $form->dropdownlist($model, 'branch_or_sponsor_id', MasCompanyBranchSponsor::getCompanyBranches(), array('data-label' => 'Branch <span style="color:red">*</span>', 'empty' => 'Select', 'data-search' => true, 'onchange' => 'getcode(this.value);hideLevedetails()'));
                } else {
                    echo $form->dropdownlist($model, 'branch_or_sponsor_id', MasCompanyBranchSponsor::getCompanyBranches(), array('data-label' => 'Branch <span style="color:red">*</span>', 'empty' => 'Select', 'data-search' => true, 'onchange' => 'hideLevedetails()'));
                }
                ?>
            </li>
            <li class="col-sm-3">
                <?php
                if ($model_general_setting->auto_increment_employee_code == 'Y') {
                    echo $form->textField($model, 'employee_code', array('data-label' => 'Employee Code <span style="color:red">*</span>', 'readonly' => true));
                } else {
                    echo $form->textField($model, 'employee_code', array('data-label' => 'Employee Code <span style="color:red">*</span>'));
                }
                ?>
            </li>	
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'employee_biometric_code', array('data-label' => 'Biometric Code <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'subledger_account_no', array('data-label' => 'Subledger Account No')); ?>
            </li> 
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'first_name', array('data-label' => 'First Name <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'last_name', array('data-label' => 'Last Name <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->dropdownlist($model, 'gender', array('1' => 'Male', '2' => 'Female'), array('data-label' => 'Gender <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-2">
                <?php
                $date_of_birth = '';
                if ($model->date_of_birth != '' && $model->date_of_birth != '0000-00-00') {
                    $date_of_birth = date("d/m/Y", strtotime($model->date_of_birth));
                }
                echo $form->textField($model, 'date_of_birth', array('data-label' => 'Date of Birth <span style="color:red">*</span>', 'value' => $date_of_birth, 'class' => 'datepicker', 'onkeypress' => 'return false;'));
                ?>
            </li>  
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'date_join', array('data-label' => 'Joining Date <span style="color:red">*</span>', 'class' => 'datepicker', 'onChange' => 'hideLevedetails()')); ?>
            </li>
            <li class="col-sm-3">
                <div class="new-cst">
                    <div class="toggle-cst"><span class="cst-btn">+</span>
                        <div class="content-cst">
                            <div class="head" ripple="ripple" ripple-color="#FFF">
                                <h5>Add New Department</h5>
                            </div>
                            <div class="body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <?php echo CHtml::textField('department_name', '', array('data-label' => 'Department <span style="color:red;">*</span>')); ?>
                                    </div>
                                </div>
                                <div class="btn-wrap text-center">
                                    <a href="javascript:void(0);" class="plan-add-btn btn btn-theme go" onclick="AddMaster('MasDepartment', 'department')">SAVE</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="department_div">
                    <?php echo $form->dropdownlist($model, 'department', MasDepartment::getDepartment(), array('data-label' => 'Department <span style="color:red">*</span>', 'empty' => 'Select', 'data-search' => true)); ?>
                </div>
            </li>
            <li class="col-sm-3">
                <div class="new-cst">
                    <div class="toggle-cst"><span class="cst-btn">+</span>
                        <div class="content-cst">
                            <div class="head" ripple="ripple" ripple-color="#FFF">
                                <h5>Add New Designation</h5>
                            </div>
                            <div class="body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <?php echo CHtml::textField('designation_name', '', array('data-label' => 'Designation <span style="color:red;">*</span>')); ?>
                                    </div>
                                </div>
                                <div class="btn-wrap text-center">
                                    <a href="javascript:void(0);" class="plan-add-btn btn btn-theme go" onclick="AddMaster('MasDesignation', 'designation')">SAVE</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="designation_div">
                    <?php echo $form->dropdownlist($model, 'designation', MasDesignation::getDesignation(), array('data-label' => 'Designation <span style="color:red">*</span>', 'empty' => 'Select', 'data-search' => true)); ?>
                </div>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropdownlist($model, 'visa_profession', MasDesignation::getDesignation(), array('data-label' => 'Visa Profession', 'empty' => 'Select', 'data-search' => true)); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropdownlist($model, 'employee_category', array(1 => 'Permanent', 2 => 'Temporary/Contract', 3 => 'Trainee'), array('data-label' => 'Category')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropdownlist($model, 'currency', MasCurrency::getCurrency(), array('data-label' => 'Currency <span style="color:red">*</span>', 'options' => array(1 => array('selected' => 'selected')))); ?>
            </li>
            <li class="col-sm-3">
                <?php 
                echo CHtml::hiddenField('flag_reporting_manager', 'N');
                echo $form->dropdownlist($model, 'reporting_manager', ReportingManager:: getReportingManager(), array('data-label' => 'Reporting Manager ', 'empty' => 'Select', 'data-search' => true,'onchange'=>'setflaglinemanager(this.value)')); ?>
            </li>
            <li class="col-sm-3">
                <?php 
                echo CHtml::hiddenField('flag_supervisor', 'N');
                echo $form->dropdownlist($model, 'attendance_manager', AttendanceManager::getAttendanceManager(), array('data-label' => 'Supervisor ', 'empty' => 'Select', 'data-search' => true,'onchange'=>'setflag(this.value)')); 
                echo CHtml::hiddenField('flag_leave', 'N');
                echo CHtml::hiddenField('flag_salary', 'N');
                echo CHtml::hiddenField('flag_level', 'N');
                ?>
            </li>
            <li class="col-sm-3">
                <?php
                // echo CHtml::hiddenField('flag_scheme', 'N');
                echo $form->dropdownlist($model, 'level_scheme', HrMasApprovalScheme:: getSchemeName(), array('data-label' => 'Approval Scheme', 'data-search' => true, 'onchange' => 'hideLeveldetails()'));
                ?>
            </li>
        </ul>

        <div class='brder-cmn'>
        <div class="row tb-emp">
            <div class="col-md-12">
                <div class="tab" role="tabpanel">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs nav-tab-theme" role="tablist">
                            <?php if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') { ?>
                                <li role="presentation"><a href="#Section1" aria-controls="home" role="tab" data-toggle="tab"  onclick="leaveInitialize()">Leave</a></li>
                        <?php } ?>
                            <?php if ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y') { ?>
                        <li role="presentation"><a href="#Section2" aria-controls="profile" role="tab" data-toggle="tab" onclick="salaryInitialize()">Salary</a></li>
                         <?php } ?>
                            <?php if ($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y') { ?>
                                <li role="presentation" id="hirerchy_level"><a href="#Section3" aria-controls="messages" role="tab" data-toggle="tab" onclick="levelInitialize()">Level</a></li>
                        <?php } ?>
                    </ul>
                    <!-- Tab panes -->
                    <div class="tab-content tabs">
                            <div role="tabpanel" class="tab-pane fade " id="Section1">
                            <div style="display:none; width: 100%" class="inr-tb-wrp" id="div_master_leave_details"></div>
                        </div>
                        <div role="tabpanel" class="tab-pane fade" id="Section2">
                            <div style="display:none; width: 100%"  class="inr-tb-wrp" id="div_master_salary_details"></div>
                        </div>
                            <div role="tabpanel" class="tab-pane fade in active" id="Section3">
                            <div style="display:none; width: 100%" class="inr-tb-wrp" id="div_master_level_details"></div>  
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" id="employee_close" data-dismiss="modal">Close</button>
        <?php
        $url = Yii::app()->createUrl('/hr/employee/SaveEmployee');
        echo CHtml::ajaxsubmitButton('Save', $url, array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Details Saved Successfully!");
                                        reloadTable("#tbl_employee_details");
                                        loadPopupModal("hr/employee/create&id="+data.id,data.employeefullname,"xl");
                                    } else { 
                                       $("#employee-form .employee-save-btn").prop("disabled", false);
                                        $("#employee-form .employee-save-btn").addClass("btn-theme").removeClass("btn_loding");
                                        $.each(data, function(key, val) {
                                                $("#employee-form #"+key+"_em_").text(val).show(); 
                                                t8.error(""+val+""); 
                                        }); 
                                    } 
                            }',
            'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#employee-form .employee-save-btn").prop("disabled", true);
                                $("#employee-form .employee-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }'
                ), array('id' => 'mybtn' . rand(), 'class' => 'employee-save-btn btn btn-theme'));
        ?>


    </div>


    <?php $this->endWidget(); ?>

    <?php
    $cs = Yii::app()->getClientScript();
    $cs->registerScript("AddMaster", "function AddMaster(from,type)
        {
            //AddMaster('MasDesignation','designation')
            if(type == 'department'){
                var url = '" . Yii::app()->createUrl('hr/department/directadd') . "';
                var name = $('#department_name').val();
                var data = {'from':from,'name':name};
                if(name == ''){
                    alert('Please Fill All Fields!');
                   return false;
                }                
            }
            else if(type == 'designation'){
                var url = '" . Yii::app()->createUrl('hr/designation/directadd') . "';
                var name = $('#designation_name').val();
                var data = {'from':from,'name':name};
                if(name == ''){
                    alert('Please Fill All Fields!');
                   return false;
                }                
            }
           
            jQuery.ajax({
                'dataType':'json',              
                'data': data,
                'type':'post',
                'url': url,
                'cache': false,
                'success': function(data) {
                       if(data.status == 'success'){
                            if(from == 'MasDepartment' && type=='department'){
                                $('#department_div').html(data.drop);
                                $('.cst-btn.expand').click();
                            }
                            else if(from == 'MasDesignation' && type=='designation'){
                                $('#designation_div').html(data.drop);
                                $('.cst-btn.expand').click();
                            }
                            
                       }else{
                               $.each(data, function(key, val) {
                                        t8.error(''+val+''); 
                               }); 
                       }
                 } 

           });
       
        }", CClientScript::POS_HEAD);

    $cs->registerScript("getcode", "function getcode(branch) {
        if(branch!=''){
            jQuery.ajax({
                'data' : {'branch':branch},
                'type':'post',
                'dataType':'json',
                'url': '" . Yii::app()->createUrl('hr/employee/codegenerate') . "',
                'cache': false,
                'success': function(data) {
                    $('#Employee_employee_code').addClass('filled');
                    $('#Employee_employee_code').val(data.code);
                }, 
                'beforeSend':function(){
                  $('#loader').show(); 
                  $('.toast8-error').hide(); 
                },
                'complete':function(){
                    $('#loader').hide();   
                }
            });     
        }else{
            $('#Employee_employee_code').addClass('filled');
            $('#Employee_employee_code').val('');
        }
    };", CClientScript::POS_HEAD);


    $cs->registerScript("leaveInitialize", "function leaveInitialize() {
        branch = $('#Employee_branch_or_sponsor_id').val(); 
        date_join =$('#Employee_date_join').val(); 
        gender =$('#Employee_gender').val(); 
        leave_balance =$('#flag_leave').val(); 
        if(leave_balance=='N' && branch!='' && date_join!=''){ $('#flag_leave').val('Y'); }
        if(leave_balance=='N'){ 
        if(branch!='' && date_join!=''){
            jQuery.ajax({
                'data' : {'branch':branch,'date_join':date_join,'gender':gender},
                'type':'post',
                
                'url': '" . Yii::app()->createUrl('hr/employee/leaveinitialize') . "',
                'cache': false,
                'success': function(data) {
                $('#div_master_leave_details').show();
                $('#div_master_leave_details').html(data);
                }, 
                'beforeSend':function(){
                  $('#loader').show();  
                  $('.toast8-error').hide(); 
                },
                'complete':function(){
                    $('#loader').hide();   
                }
            });     
        }else{
            if(branch==''){ 
                t8.error('Please Select branch');
            }
            if(date_join==''){ 
                t8.error('Please Select Date of Join');
            }
            
        }
        }
    };", CClientScript::POS_HEAD);

    $cs->registerScript("calculateleave", "function calculateleave(field_id) {
    var arr_fields 		= field_id.split('_');
    var model_name 		= arr_fields[0];
    var row_id 			= arr_fields[1];
    var row_field_name 	= arr_fields[2];
    var id=$('#EmployeeLeave_'+row_id+'_id').val();
    if(parseInt(id)<=0 || id==''){
        var total_leave=0.00;      
        var opening_balance=$('#EmployeeLeave_'+row_id+'_leave_opening').val();
        var leave_addition=$('#EmployeeLeaveLedger_'+row_id+'_leave_count').val();      
        var leave_deduction=$('#EmployeeLeaveLedger_'+row_id+'_leave_reduce').val();
        if(Number(opening_balance)>0 || Number(opening_balance)<0){
            total_leave+=Number(opening_balance)
        }
        if(parseFloat(leave_addition)>0){
            total_leave+=parseFloat(leave_addition)
        }
        if(parseFloat(leave_deduction)>0){
            total_leave-=parseFloat(leave_deduction)
        }
        $('#EmployeeLeave_'+row_id+'_leave_current_balance').val(total_leave.toFixed(2));
    }else{
        var total_leave=0.00;
        var current_balance=$('#EmployeeLeave_'+row_id+'_current_balance').val();
        var leave_addition=$('#EmployeeLeaveLedger_'+row_id+'_leave_count').val();      
        var leave_deduction=$('#EmployeeLeaveLedger_'+row_id+'_leave_reduce').val();
        if(parseFloat(current_balance)>=0 || parseFloat(current_balance)<=0){
            total_leave+=parseFloat(current_balance)
        }
        if(parseFloat(leave_addition)>0){
            total_leave+=parseFloat(leave_addition)
        }
        if(parseFloat(leave_deduction)>0){
            total_leave-=parseFloat(leave_deduction)
        }
        $('#EmployeeLeave_'+row_id+'_leave_current_balance').val(total_leave.toFixed(2));
    }
};", CClientScript::POS_HEAD);

    $cs->registerScript("hideLevedetails", "function hideLevedetails() { 
        $('#div_master_leave_details').hide();
        $('#div_master_salary_details').hide();
        $('#flag_leave').val('N')
        $('#flag_salary').val('N')
    };", CClientScript::POS_HEAD);
    $cs->registerScript("setflag", "function setflag(id) { 
        if(id>0){
            $('#flag_supervisor').val('Y');
        }else{
            $('#flag_supervisor').val('N');
        }
    };", CClientScript::POS_HEAD);
    $cs->registerScript("setflaglinemanager", "function setflaglinemanager(id) {  
        if(id>0){
            $('#flag_reporting_manager').val('Y');
        }else{
            $('#flag_reporting_manager').val('N');
        }
    };", CClientScript::POS_HEAD);
        $cs->registerScript("setflagscheme", "function setflagscheme(id) {  
        if(id>0){
            $('#flag_scheme').val('Y');
        }else{
            $('#flag_scheme').val('N');
        }
    };", CClientScript::POS_HEAD);
    $cs->registerScript("hideLeveldetails", "function hideLeveldetails() { 
        $('#div_master_level_details').hide();
        $('#flag_level').val('N')
        $('#flag_scheme').val('N')
        levelInitialize();
        
    };", CClientScript::POS_HEAD);
    $cs->registerScript("salaryInitialize", "function salaryInitialize() {
        branch = $('#Employee_branch_or_sponsor_id').val(); 
        date_join =$('#Employee_date_join').val(); 
        gender =$('#Employee_gender').val(); 
        amount =$('#flag_salary').val(); 
        if(amount=='N' && branch!='' && date_join!=''){ $('#flag_salary').val('Y'); }
        if(amount=='N'){ 
            if(branch!='' && date_join!=''){
                jQuery.ajax({
                    'data' : {'branch':branch,'date_join':date_join,'gender':gender},
                    'type':'post',

                    'url': '" . Yii::app()->createUrl('hr/employee/salaryinitialize') . "',
                    'cache': false,
                    'success': function(data) {
                    $('#div_master_salary_details').show();
                    $('#div_master_salary_details').html(data);
                    }, 
                    'beforeSend':function(){
                      $('#loader').show();   
                      $('.toast8-error').hide(); 
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }else{
                if(branch==''){ 
                    t8.error('Please Select branch');
                }
                if(date_join==''){ 
                    t8.error('Please Select Date of Join');
                }
               }
        }
    };", CClientScript::POS_HEAD);
        $cs->registerScript("levelInitialize", "function levelInitialize() {
        scheme = $('#Employee_level_scheme').val(); 
        maxlevel  =$('#flag_level').val(); 
        if(maxlevel=='N' && scheme!=''){ $('#flag_level').val('Y'); }
        if(maxlevel=='N'){ 
            if(scheme!=''){
                jQuery.ajax({
                    'data' : {'scheme':scheme},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('hr/employee/levelinitialize') . "',
                    'cache': false,
                    'success': function(data) {
                    $('#Section3').click();
                    $('#hirerchy_level').addClass('active');
                    $('#div_master_level_details').show();
                    $('#div_master_level_details').html(data);
                    }, 
                    'beforeSend':function(){
                      $('#loader').show(); 
                      $('.toast8-error').hide(); 
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
                }
            /*else{
                if(scheme==''){ 
                    t8.error('Please Select Scheme');
            }
            }*/
        }
    };", CClientScript::POS_HEAD);
    ?>
    <script>
        $('#Employee_date_join').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.hide', function (e) {
            hideLevedetails();
        });
            $(document).ready(function () {
                levelInitialize();
            });
    </script>