<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable()
    {
        var table_id ="#tbl_document_expiry";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
            pageLength      : 50,
            processing: true,           
            bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/documentexpiry/GetExpiryList') . '",
                type: "POST",
                cache : false,
            },
            columnDefs: [
                {
                   "targets": [6,7],"visible": false,
                },
            ],
            order: [5, "asc" ],
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }, 
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
                 if (aData[7] == "1"){
                $("td", nRow).css("background-color", "#97c997");
            }else if (aData[7] == "2"){
                $("td", nRow).css("background-color", "#fbb2a1");
            }else if (aData[7] == "3"){
                $("td", nRow).css("background-color", "#d9aa55");
            }else if (aData[7] == "4"){
                $("td", nRow).css("background-color", "#fc0e03");
            }    
            }
        });
        $(".dataTables_scrollFoot").hide();
    }	
    $(document).ready(function() {  	 	
        filterDataTable();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[6].update_button !== 0) {
            items.edit = {
                name: "Update",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/documentexpiry/editdocument&id=" + datas[6].id, datas[6].employee_name, "lg");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE; font-size: 10px;">
    <header class="panel-heading clearfix panel-theame">Employee Document Expiry
        <div class="pull-right"></div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_document_expiry" style="font-size:12px;width: 100%;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch</th>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Document</th>
                        <th>Expiry</th>
                        <th>Action</th> 
                        <th></th>
                    </tr>
                </thead>
            </table>
        </div>
        <div class="color-indicator pull-left">
            <span style="display: inline-block;width:30px;height:30px; box-shadow: 0px 2px 10px 2px #F88017; background-color: #fbb2a1" class="bg-danger"></span><span class="verti">Expired</span>
            <span style="display: inline-block;width:30px;height:30px; box-shadow: 0px 2px 10px 2px #F88017; background-color: #97C997" class="bg-danger"></span><span class="verti">Expiring</span>
            <span style="display: inline-block;width:30px;height:30px; box-shadow: 0px 2px 10px 2px #F88017; background-color: #FFFFFF" class="bg-danger"></span><span class="verti">Expiring(15 Days)</span>
            <!--<span style="display: inline-block;width:30px;height:30px; box-shadow: 0px 2px 10px 2px #F88017; background-color: #fc0e03" class="bg-danger"></span><span class="verti">Cancelled</span>-->

        </div>
    </div>
</section>
