<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable()
    {
        var table_id ="#tbl_catalogue_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
            pageLength      : 50,
            processing: true,    
            ajax: {
                url: "' . Yii::app()->createUrl('hr/catalogue/GetList') . '",
                type: "POST",
                cache : false,
            },
            columnDefs: [
                { "bSortable": false, "aTargets": [0,1,2,3,4] },
            ],
            order: [[ 5, "desc" ]],
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
            
        });
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  	 	
        filterDataTable(); 
    });', CClientScript::POS_HEAD);
$cs->registerScript("deletecatalogue", "function deletecatalogue(id){
    var r = confirm('Are you sure want to delete this catalogue?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'dataType'  : 'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=hr/catalogue/deletecatalogue',
              'cache': false,
              'success':function(data){
                if(data.status=='success'){
                    reloadTable('#tbl_catalogue_details');
                    t8.success('Deleted SuccessFully!');
                }else {
                   t8.error('Error');
                }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[6].edit_catalogue !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/catalogue/create&id="+datas[6].id, "Edit Catalogue", "xl");
                }
            };
        }
        if (datas[6].delete_catalogue !== 0) {
            items.Delete = {
                name: "Delete",
                icon: "fa-trash-o",
                callback: function () {
                     deletecatalogue(datas[6].id);
                }
            };
        }
        if (datas[6].Download_catalogue !== 0) {
            items.download = {
                name: "Download",
                icon: "fa-download",
                callback: function () {
                    window.open($('#liveSite').val() + "/index.php?r=hr/catalogue/downloadcatalogue&id==" + datas[6].id, "_blank");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
         Catalogue
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_catalogue_add']) || Yii::app()->user->authorised_user == 1) { ?>
            <a class="ad-btn" onclick="loadPopupModal('hr/catalogue/create','Catalogue', 'xl')" title="Add Catalogue">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a> &nbsp;
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_catalogue_details" style="font-size:13px;width: 100%;">
                <thead>
                    <tr>
                        <th class="text-center">No</th>
                        <th class="text-center">Branch</th>
                        <th class="text-center">Department</th>
                        <th class="text-center">Title</th>
                        <th class="text-center">Catalogue</th>
                        <th class="text-center">Created On</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
