<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'catalogue-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
$model_upload_catelogue = HrMasterUpload::model()->findByPK(26);
$upload_catelogue_size = $model_upload_catelogue->max_upload_size * 1024 * 1024;

?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php
                $selected_branch=array();
                if ($model->branch_or_sponsor_id!='') {
                    $branch = explode(",", $model->branch_or_sponsor_id);
                    foreach ($branch as $eachValue){
                        $selected_branch[$eachValue] = array('selected' => 'selected');
                    }
                }
                echo $form->dropdownlist($model, 'branch_or_sponsor_id',MasCompanyBranchSponsor::getCompanyBranches(), array('data-label' => 'Branch','data-search'=>true,'multiple'=>true, 'options' => $selected_branch)); ?>
            </li>
            <li class="col-sm-3">                
                <?php 
                $selected_department=array();
                if ($model->department_id!='') {
                    $department_id = explode(",", $model->department_id);
                    foreach ($department_id as $eachValue){
                        $selected_department[$eachValue] = array('selected' => 'selected');
                    }
                }
                echo $form->dropdownlist($model, 'department_id',MasDepartment::getDepartment(), array('data-label' => 'Department','data-search'=>true,'multiple'=>true, 'options' => $selected_department)); ?>
            </li>
            <li class="col-sm-3">                
                <?php echo $form->textField($model, 'title', array('data-label' => 'Title <span style="color:red;">*</span>')); ?>
            </li>
            <?php if($model_upload_catelogue->isActive=="Y"){ ?>
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php
                echo $form->labelEx($model, 'Upload Details (Max 2 MB)');
                $allowedExtensions = array("png", "txt", "pdf", "doc", "docx", "jpg", "jpeg","xlsx","csv","xls");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => rand(),
                    'config' => array(
                        'action' => Yii::app()->createUrl('hr/'.Yii::app()->controller->id . '/Upload', array('folder' => 'uploads/upload_catalogue')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => $upload_catelogue_size,
                        'onStart' => "js:function(){}",
                        'onComplete' => "js:function(id, fileName, responseJSON){
                            $('#CompanyCatalogue_catalogue_attachment').val(responseJSON.filename); 
                        }",
                    )
                ));
                ?>   
                <?php echo $form->hiddenField($model, 'catalogue_attachment'); ?>
            </li>
            <?php } ?>
           <li class="col-sm-12">
                   <?php echo $form->labelEx($model, 'Description <span style="color:red;">*</span>'); ?>
                   <?php echo $form->textArea($model, 'notes', array('data-label' => 'Description <span style="color:red;">*</span>', 'class' => 'ckeditor go', 'id' => 'CompanyCatalogue_notes')); ?>
           </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="catalogue_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/catalogue/savecatalogue');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'data'=>'js:$("#catalogue-form").serialize()+"&notes="+encodeURIComponent(CKEDITOR.instances.CompanyCatalogue_notes.getData())',
        'type' => 'post',
        'success' => 'function(data) {
            if(data.status=="success"){  
                 t8.success("Details Saved Successfully!");
                 $("#catalogue_close").click();
                reloadTable("#tbl_catalogue_details");
            } else { 
                $.each(data, function(key, val) {
                    t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $(".toast8-error").hide(); 
            $("#catalogue-form .catalogue-save-btn").prop("disabled", true);
            $("#catalogue-form .catalogue-save-btn").addClass("btn_loding").removeClass("btn-theme");
        }',
        'complete'=>'function(data) {
            $("#catalogue-form .catalogue-save-btn").prop("disabled", false);
            $("#catalogue-form .catalogue-save-btn").addClass("btn-theme").removeClass("btn_loding");
            $("#loader").hide();
        }',
    ), array('id' => 'mybtn' . rand(), 'class' => 'catalogue-save-btn btn btn-theme'));
    ?>


</div>


<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("onready", "$(document).ready(function(){
var editor = CKEDITOR.instances['CompanyCatalogue_notes'];
    if (editor) { editor.destroy(true); }
    CKEDITOR.replace('CompanyCatalogue_notes',
        {
             filebrowserImageUploadUrl: 'js/ckeditor/filemanager/connectors/php/upload.php?Type=Image',
        });
});", CClientScript::POS_HEAD);
