<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadData", '
        $(document).ready(function() {

        var table_id ="#tbl_branch_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/branch/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
             "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            
              if ( aData[6].status == "N" )  {  
                    $("td", nRow).addClass("bg-danger");
                }      
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[6].edit !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/branch/create&id=" + datas[6].id, datas[1], "xl");
                }
            };
        }
        if (datas[6].disable !== 0) {
            items.disable = {
                name: (datas[6].status== "Y") ? "Disable" : "Enable",
                icon: (datas[6].status == "Y") ? "fa-toggle-off" : "fa-toggle-on",
                callback: function () {
                    Disable(datas[6].id, datas[6].status);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true)
        {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=hr/branch/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_branch_details').DataTable().ajax.reload()
                        t8.success(' Disabled/ Enabled Successfully!');
                    }
                }
            });
        }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
         Branch
        <?php 
        $notice_flag=0;
        $model_mas_company = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $total_branch_count = MasCompanyBranchSponsor::model()->count(array('condition' => 'isActive="Y"'));
        if ($total_branch_count < $model_mas_company->total_branches_allowed) {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_branch_add']) || Yii::app()->user->authorised_user == 1) {
                ?>
                <div class="pull-right">
                    <!-- <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/branch/create', 'Add New Branch', 'xl')"><i class="fa fa-plus"></i></button> -->
                   <a class="ad-btn"  onclick="loadPopupModal('hr/branch/create','Add New Branch','xl')" title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
                </div>
            <?php
            }
        } else { 
            $notice_flag=1;
        }
        ?>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <?php
            if($notice_flag==1){
            ?>
                <div class="announcement-box">
                    <div class="announcement-icon blink-icon">
                      <i class="fa fa-bullhorn"></i>
                    </div>
                    <div class="announcement-text">
                      Please purchase additional license for adding new Branches !!!
                    </div>
                </div>
            <?php } ?>
            <table class="table table-hover table-bordered personal-task" id="tbl_branch_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch Name</th>
                        <th>Location</th>
                        <th>Phone Number</th>
                        <th>Email</th>
                        <th>Branch Value</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
