<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'emp_attenendance_upload_form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
$model_upload_attendance_daily = HrMasterUpload::model()->findByPK(10);
$upload_daily_size =$model_upload_attendance_daily->max_upload_size * 1024 * 1024;
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4" id="employeesattendanceuploadndexdropdown">
                <?php echo CHtml::dropdownlist('attendance_branch', '', MasCompanyBranchSponsor::getCompanyBranches(), array('prompt' => '--Select--', 'data-label' => 'Branch <span style="color : red;">*</span>', 'data-search'=>true,'class' => 'tooltipster', 'title' => 'Please select Branch', 'onchange' => 'viewupload(); branchsalarylocked(this.value);')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::textField('date_from', '', array('class' => 'datepicker', 'data-label' => 'Date <span style="color : red;">*</span>','onkeypress' => 'return false;')); ?>
            </li>
            
            <li class="col-sm-4" id="attdnc_upload" style="display: none">
                <label>Upload  <span style="color : red;">*</span> ( CSV Only )</label>
                <?php
                $allowedExtensions = array("csv");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => rand(),
                    'config' => array(
                        'action' => Yii::app()->createUrl('hr/'.Yii::app()->controller->id . '/UploadAttendaceCsv', array('folder' => 'uploads/attendance/')),
                        'multiple' => false,
                        'allowedExtensions' => $allowedExtensions,
                        'sizeLimit' => $upload_daily_size,
                        'onStart' => "js:function(){}",
                        'onComplete' => "js:function(id, fileName, responseJSON){                                    
                                                    $('#attendance_file').val(responseJSON.filename);                           
                                                }",
                    )
                ));
                ?>  
                <?php echo CHtml::hiddenField('attendance_file', ''); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <?php // echo CHtml::link('Download template',array('attendance/downloadattendanceformat'), array('target'=>'_blank','class'=>"btn btn-primary pull-left")); ?>
    <!--<a href="javascript:void(0);" onclick="downloadattendanceformat();" class="btn btn-primary attnd_dwld_1 pull-left">Download Format</a>-->
    <button type="button" id="attendance_upload_close_btn" class="btn btn-danger" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('hr/attendance/SaveAttendanceUpload');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                        if(data.status=="success"){  
                             t8.success("Success!");
                            $("#attendance_upload_close_btn").click();
                        } 
                        else if(data.status=="fail"){
                            t8.error("Failed!"); 
                        }else { 
                             $.each(data, function(key, val) {
                                    t8.error(""+val+""); 
                                }); 
                        } 
                }',
        'beforeSend' => 'function(){
                    var attendance_file       = $("#attendance_file").val();
                    var date_from       = $("#date_from").val();
                    var attendance_branch       = $("#attendance_branch").val();
                    if(attendance_branch == ""){
                        t8.error("Please Select Branch");
                        return false;
                    }
                    else if(date_from ==""){                                    
                        t8.error("Please Select Date");
                         return false;
                    }
                    else if(attendance_file ==""){                                    
                        t8.error("Upload CSV file");
                         return false;
                    }
                    else{
                         $("#loader").show();
                    }
                }',
        'complete' => 'function(){
                    $("#loader").hide();
                }',
            ), array('id' => 'mybtn' . rand(), 'class' => 'btn btn-theme'));
    ?>
</div>
<input type="hidden" id="max_date" value="<?php echo date("d/m/Y"); ?>" />    


<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    var max_date = $('#max_date').val().split('/');
        var max_date = new Date(max_date[2], max_date[1] - 1, max_date[0]);
        $('#date_from').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'});
});", CClientScript::POS_HEAD);
$cs->registerScript("viewupload", "function viewupload(branch) { 
     var date_from= $('#date_from').val();
     var branch= $('#attendance_branch').val();
            if(branch!='' && date_from!=''){
            $('#attdnc_upload').show();
            }else{    
            $('#attdnc_upload').hide();
            }
    };", CClientScript::POS_HEAD);

$cs->registerScript("showupload", "
    $('#date_from').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
        var date_from= $('#date_from').val();
        var branch= $('#attendance_branch').val();
            if(branch!='' && date_from!=''){
                $('#attdnc_upload').show();
            }else{    
                $('#attdnc_upload').hide();
            }
    });", CClientScript::POS_HEAD);

$cs->registerScript("downloadattendanceformat", "function downloadattendanceformat() { 
//    var branch=$('#attendance_branch').val();
//    if(branch!=''){
        window.open($('#liveSite').val()+'index.php?r=hr/attendance/downloadattendanceformat&branch='+branch, '_blank');
//    }else{    
//     t8.error('Select Branch');
//    }
};", CClientScript::POS_HEAD);
$cs->registerScript("branchsalarylocked", "function branchsalarylocked(branch) {
        jQuery.ajax({
            'dataType':'json', 
            'data': {'branch':branch}  ,
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/attendance/getbranchsalarylocked') . "',    
            'cache': false,
            'success': function(data) {              
                var salary_lock_leave=data.lock_attendance_leave; 
                var last_salary_locked=data.last_locked_date;
                if(salary_lock_leave=='Y' && last_salary_locked!=''){
                    last_salary_locked=last_salary_locked.split('/');
                    var current_1 = new Date(last_salary_locked[2], last_salary_locked[1] - 1, last_salary_locked[0]);
                    $('#date_from').data('DateTimePicker').minDate(current_1);
                }
            }
        });
};", CClientScript::POS_HEAD);
?>

<script>
 $(document).ready(function() {  	 	
         materializing(".material"); 
    });
</script>