<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'emp_monthly_attenendance_form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">            
            <li class="col-sm-3">
                <?php echo CHtml::dropdownlist('attendancebranch', '', MasCompanyBranchSponsor::getCompanyBranches(), array('prompt' => '--Select--', 'data-label' => 'Branch <span style="color : red;"> *</span>','data-search'=>true,'title' => 'Please select Branch', 'onchange' => 'viewEmpList();')); ?>
            </li>
            <li class="col-sm-4" id="employee_li">
                <?php echo CHtml::dropdownlist('monthly_employee_id', '',array(), array('prompt'=>'Select','data-label' => 'Employee <span style="color : red;"> *</span>', 'data-search'=>true, 'title' => 'Please select Employee','data-search'=>true)); ?>
             </li>
            <li class="col-sm-2">
                <?php echo CHtml::textField('date_from',date("d/m/Y"), array('class' => 'datepicker', 'data-label' => 'From Date','onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo CHtml::textField('date_to', date("d/m/Y"), array('class' => 'datepicker', 'data-label' => 'To Date','onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-1">
                <a href="javascript:void(0);" onclick="loadEmployeeMonthlyAttendance();" class="btn btn-primary">Load</a>
            </li>
        </ul>
        <div id="div_load_attendance"></div>
        <input type="hidden" id="max_date" value="<?php echo date("d/m/Y"); ?>" />
    </div>
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("viewEmpList", "function viewEmpList() { 
            var branch       = $('#attendancebranch').val();
            if(branch!=''){
                jQuery.ajax({
                        'data' : {
                            'branch':branch,
                        },
                        'dataType':'json', 
                        'type':'post',
                        'url': '" . Yii::app()->createUrl('hr/attendance/getEmployeeList') . "',
                        'cache': false,
                        'success': function(data) {
                            $('#employee_li').show();
                            $('#employee_li').html(data.employee);
                        },
                        'beforeSend': function(data) {  
                            $('#loader').show();
                        },
                        'complete': function(data) {  
                            $('#loader').hide();
                        }
                });
            }else{ 
                $('#employee_li').hide();
                t8.error('Select Branch');
            }
    };", CClientScript::POS_HEAD);

$cs->registerScript("loadEmployeeMonthlyAttendance", "function loadEmployeeMonthlyAttendance() {
        var from_date   = $('#date_from').val();
        var to_date     = $('#date_to').val();
        var branch      = $('#attendancebranch').val();
        var emp_id      = $('#monthly_employee_id').val();
        
        var date_from   = from_date.split('/').reverse().join('-'); 
        var date_to     = to_date.split('/').reverse().join('-');  
        
        if(date_from!='' && date_to !='' && branch !='' && emp_id !=''){
            
            jQuery.ajax({
                'data' : {
                  emp_id : emp_id,
                  date_from : date_from,
                  date_to : date_to
                },
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/attendance/GetEmployeeForMonthlyAttendance') . "',    
                'cache': false,
                'success': function(data) {  
                    $('#div_load_attendance').html(data);
                },
                'beforeSend': function(data) {  
                    $('#loader').show();
                },
                'complete': function(data) {  
                    $('#loader').hide();
                }
            });
        }else{
            if(branch==''){
              t8.error('Select Branch');
            }else if(emp_id==''){
                t8.error('Select Employee');
            }else if(date_from==''){
                t8.error('Select From Date');
            }else if(date_to==''){
                t8.error('Select To Date');
            }
           
        }
    };", CClientScript::POS_HEAD);
$cs->registerScript("branchsalarylocked", "function branchsalarylocked(employeeid) {
        jQuery.ajax({
            'dataType':'json', 
            'data': {'employeeid':employeeid}  ,
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/attendance/getsalarylockeddate') . "',    
            'cache': false,
            'success': function(data) {              
                var salary_lock_leave=data.lock_attendance_leave; 
                var last_salary_locked=data.last_locked_date;
                if(salary_lock_leave=='Y' && last_salary_locked!=''){
                    last_salary_locked=last_salary_locked.split('/');
                    var current_1 = new Date(last_salary_locked[2], last_salary_locked[1] - 1, last_salary_locked[0]);
                    $('#date_from').data('DateTimePicker').minDate(current_1);
                    $('#date_to').data('DateTimePicker').minDate(current_1);
                    $('#attendance_date_from_emp').datetimepicker({minDate: current_1, format: 'DD/MM/YYYY'});
                }else if(salary_lock_leave=='N' && last_salary_locked!=''){
                    last_salary_locked=last_salary_locked.split('/');
                    var current_1 = new Date(last_salary_locked[2], last_salary_locked[1] - 1, last_salary_locked[0]);
                    $('#date_from').data('DateTimePicker').minDate(current_1);
                    $('#date_to').data('DateTimePicker').minDate(current_1);
                    $('#attendance_date_from_emp').datetimepicker({minDate: current_1, format: 'DD/MM/YYYY'});
                }
            }
        });
};", CClientScript::POS_HEAD);
?>
<script type="text/javascript">
    $(function () {
        var max_date = $("#max_date").val().split("/");
        var max_date = new Date(max_date[2], max_date[1] - 1, max_date[0]);
        $('#date_from').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'});
        $('#date_to').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'});
    });
</script>
