<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadData", '
    function filterDataTable(branch,empid,date_from,date_to)
    {
        var table_id ="#tbl_attendance_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/attendance/GetList') . '",
                type: "POST",
                "data" : {
                    "branch_id" : branch,
                    "empid" : empid,
                    "from_date" : date_from,
                    "to_date" : date_to,
                },
                cache : false,
                "beforeSend": function(data) {  
                    $("#loader").show();
                },
                "complete": function(data) {  
                    $("#loader").hide();
                }
            },
            order: [[ 5, "asc" ], [ 3, "asc" ]],
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );

        $(".dataTables_scrollFoot").hide(); 
    }        
    $(document).ready(function() { 
        var branch       = $("#attendancebranch1").val();
        var empid        = $("#employee_id").val();
        var from_date    = $("#attnd_fromdate").val();
        var to_date      = $("#attnd_todate").val();
        var date_from = from_date.split("/").reverse().join("-");
        var date_to   = to_date.split("/").reverse().join("-");
      filterDataTable(branch,empid,date_from,date_to);
       materializing(".material"); 
});', CClientScript::POS_HEAD);
$cs->registerScript("loadAttendance", "function loadAttendance(){  
    $('#tbl_attendance_details').DataTable().destroy();
        var branch       = $('#attendancebranch1').val();
        var empid        = $('#employee_id').val();
        var from_date    = $('#attnd_fromdate').val();
        var to_date      = $('#attnd_todate').val();
        var date_from = from_date.split('/').reverse().join('-');
        var date_to   = to_date.split('/').reverse().join('-');
    filterDataTable(branch,empid,date_from,date_to);
   
};", CClientScript::POS_HEAD);

$cs->registerScript("viewEmpList", "function viewEmpList() { 
    var branch       = $('#attendancebranch1').val();         
        jQuery.ajax({
                'data' : {
                    'branch':branch,
                },
                'dataType':'json', 
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/attendance/EmployeeList') . "',
                'cache': false,
                'success': function(data) {
                    $('#employee_li_div').show();
                    $('#employee_li_div').html(data.employee);
                }
        });
    };", CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
        if (datas[10].attendance_edit_lock !== 0) {
            items.attendancelock = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/attendance/editattendance&id=" + datas[10].id, "Edit Attendance", "lg");
                }
            };
        }
        if (datas[10].attendance_edit_no_lock !== 0) {
            items.attendanceunlock = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/attendance/editattendance&id=" + datas[10].id, "Edit Attendance", "lg");
                }
            };
        }

        if (datas[10].overtime_edit_lock !== 0) {
            items.overtimelock = {
                name: "Overtime",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/attendance/editattendance&id=" + datas[10].id, "Edit Attendance", "lg");
                }
            };
        }
        if (datas[10].overtime_edit_no_lock !== 0) {
            items.overtimeunlock = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/attendance/editattendance&id=" + datas[10].id, "Edit Attendance", "lg");
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
 <style>
    #employeeattendanceindexdropdown .material-select-label {
        display: none;
    }
    </style>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame"> Attendance
        <div class="pull-right dis-flx">
        <div class="material col-sm-12 pd-zero" id="employeeattendanceindexdropdown"> 
           
            <?php //echo CHtml::dropdownlist('designation1','',MasDesignation::getDesignationName(),  array('prompt' => '-- Designation --', 'title' => 'Please select designation','onchange'=>'viewEmpList();')); ?>
           
       
       
           
           <span id="employee_li_div" class="col-sm-5 pull-right"><?php echo CHtml::dropdownlist('employee_id', "", Employee::getEmployee(), array( 'prompt' => '-- Employee --','data-search'=>true), array()); ?></span>
            <span class="col-sm-4 pull-right"> 
            <?php echo CHtml::dropdownlist('attendancebranch1', '', MasCompanyBranchSponsor::getCompanyBranches(), array( 'prompt' => '-- Branch --', 'title' => 'Please select Branch','data-search'=>true, 'onchange' => 'viewEmpList();')); ?>
            </span>
           </div>
          <div class="col-sm-4 pd-zero"> <?php echo CHtml::textField('attnd_fromdate', date("d/m/Y"), array('class' => 'datepicker  form-control_1', 'data-label' => 'Date')); ?> </div>
          <div class="col-sm-4 pd-zero">  <?php echo CHtml::textField('attnd_todate', date("d/m/Y"), array('class' => 'datepicker col-sm-2 form-control_1', 'data-label' => 'Date')); ?></div>
            <div class="col-sm-2 pd-zero"> <a href="javascript:void(0);" onclick="loadAttendance();" class="btn btn-primary srch-atnd" style="height:35px;"><i class="fa fa-search" style=" line-height: 19px;"></i></a></div>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_attendance_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Branch</th>
                        <th>Employee Code</th>
                        <th>Name</th>                            
                        <th>Designation</th>
                        <th>Date / Day</th>
                        <th>Login Time</th>
                        <th>Logout Time</th>
                        <th>OverTime</th>
                        <th>Status</th>
                    </tr>
                </thead>
                
            </table>
        </div>
        <input type="hidden" id="attendancemax_date_from" value="<?php echo date("d/m/Y"); ?>" />  
    </div>
</section>
<script type="text/javascript">
    $(function () {
        var max_date = $("#attendancemax_date_from").val().split("/");
        var max_date = new Date(max_date[2], max_date[1] - 1, max_date[0]);
        $('#attnd_fromdate').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'});
        $('#attnd_todate').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'});
        $('#attnd_todate').data('DateTimePicker').minDate(max_date);  
        $('#attnd_fromdate').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#attnd_todate').data('DateTimePicker').minDate(e.date);  
        })
        $('#attnd_todate').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.change', function (e) {
            $('#attnd_fromdate').data('DateTimePicker').maxDate(e.date);  
        })
    });
</script>
