<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'emp_attenendance_upload_form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">            
            <li class="col-sm-4">
                <?php echo CHtml::dropdownlist('attendancebranch', '', MasCompanyBranchSponsor::getCompanyBranches(), array('prompt' => '--Select--', 'data-label' => 'Branch <span style="color : red;"> *</span>','data-search'=>true,'class' => 'tooltipster', 'title' => 'Please select Branch', 'onchange' => 'branchsalarylocked(this.value);')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo CHtml::dropdownlist('shift_id_val', '', MasShift::getShift(), array('prompt' => 'All', 'data-label' => 'Shift', 'data-search'=>true,'class' => 'tooltipster', 'title' => 'Please select Shift')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo CHtml::textField('date_from', date("d/m/Y"), array('class' => 'datepicker', 'data-label' => 'Date', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-2">
                <a href="javascript:void(0);" onclick="loademployeeattendance();" class="btn btn-primary">Load</a>
            </li>
        </ul>
        <div id="div_attendance_employees_list"></div>
    </div>
    <input type="hidden" id="max_date" value="<?php echo date("d/m/Y"); ?>" />    
</div>
<?php $this->endWidget();
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    var max_date = $('#max_date').val().split('/');
        var max_date = new Date(max_date[2], max_date[1] - 1, max_date[0]);
        $('#date_from').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'});
});", CClientScript::POS_HEAD);
$cs->registerScript("branchsalarylocked", "function branchsalarylocked(branch) {
        jQuery.ajax({
            'dataType':'json', 
            'data': {'branch':branch}  ,
            'type':'post',
            'url': '" . Yii::app()->createUrl('hr/attendance/getbranchsalarylocked') . "',    
            'cache': false,
            'success': function(data) {              
                var salary_lock_leave=data.lock_attendance_leave; 
                var last_salary_locked=data.last_locked_date;
                if(salary_lock_leave=='Y' && last_salary_locked!=''){
                    last_salary_locked=last_salary_locked.split('/');
                    var current_1 = new Date(last_salary_locked[2], last_salary_locked[1] - 1, last_salary_locked[0]);
                    $('#date_from').data('DateTimePicker').minDate(current_1);
                    $('#date_from').addClass('filled');
                }
            }
        });
};", CClientScript::POS_HEAD);
$cs->registerScript("loademployeeattendance", "function loademployeeattendance() {
        var from_date = $('#date_from').val();
        var shift_id = $('#shift_id_val').val();
        var attendancebranch = $('#attendancebranch').val();
        var date_from = from_date.split('/').reverse().join('-');  
        if(date_from!='' && attendancebranch!=''){
            
            jQuery.ajax({
                'data' : {
                    'attendancebranch':attendancebranch,
                    'shift_id':shift_id,
                    'from_date':date_from
                },
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/attendance/dailyAttendanceEmployeeList') . "',
                'cache': false,
                'success': function(data) {
                    $('#div_attendance_employees_list').html(data);
                },
                'beforeSend': function(data) {
                    $('#loader').show();
                },
                'complete': function(data) {
                    $('#loader').hide();
                },
        });
        }else{
            if(date_from=='' && attendancebranch==''){
              t8.error('Select Date and Branch');
            }else if(date_from==''){
                t8.error('Select Date');
            }else if(attendancebranch==''){
                t8.error('Select Branch');
            }
           
        }
    };", CClientScript::POS_HEAD);
?>

