<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'hiringattendance-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo CHtml::dropDownList('hiring_branch_id', '', MasCompanyBranchSponsor::getCompanyBranches(), array('data-label' => 'Branch', 'empty' => 'Select','onchange'=>'getlastlockeddate(this.value);')); ?>
            </li>
             <li class="col-sm-3">
                <?php echo CHtml::textfield('hiring_attendance_start', '', array('data-label' => 'Date From','class'=>'datepicker')); ?>
            </li>
             <li class="col-sm-3">
                <?php echo CHtml::textfield('hiring_attendance_end', '', array('data-label' => 'Date To','class'=>'datepicker')); ?>
            </li>
            <li class="col-sm-3">
                <button type="button" class="btn btn-theme " onclick="loadhiringattendance();">Load</button>    
            </li>
        </ul>
        <div id="employee_hiring_attendance"></div>
    </div>
</div>
<?php
$this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadhiringattendance", "function loadhiringattendance() {
        var branch  = $('#hiring_branch_id').val();
        var start_date  = $('#hiring_attendance_start').val();
        var start_end  = $('#hiring_attendance_end').val();
        if(branch!='' && start_date!='' && start_end!=''){
            jQuery.ajax({
                'data' : {'branch':branch,'start_date':start_date,'start_end':start_end},
                'type':'post',
                'url': '" . Yii::app()->createUrl('hr/attendance/loadhiringattendance') . "',
                'cache': false,
                'success': function(data) {
                    $('#employee_hiring_attendance').html(data);
                }, 
                'beforeSend':function(){
                  $('#loader').show();                      
                },
                'complete':function(){
                    $('#loader').hide();   
                }
            });     
        }else{
            if(branch==''){
                t8.error('Select Branch'); 
            }else if(start_date==''){
                t8.error('Select Start Date'); 
            }else if(start_end==''){
                t8.error('Select End Date'); 
            }
        }
    };", CClientScript::POS_HEAD);
$cs->registerScript("getlastlockeddate", "function getlastlockeddate(branch_id) {
    jQuery.ajax({
        'dataType':'json',
        'data' : {'branch_id':branch_id},
        'type':'post',
        'url': '" . Yii::app()->createUrl('hr/attendance/getlastlockeddate') . "',
        'cache': false,
        'success': function(data) {
            if(data.status=='success'){
                var last_salary_locked = data.start_date.split('/');  
                var current_1 = new Date(last_salary_locked[2], last_salary_locked[1] - 1, last_salary_locked[0]);
                $('#hiring_attendance_start').data('DateTimePicker').minDate(current_1);
                $('#hiring_attendance_end').data('DateTimePicker').minDate(current_1);
            }else{
                t8.error('Error');
            } 
        },         
    });     
};", CClientScript::POS_HEAD);
?>

