<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadAppraisal", 'function filterDataTable() {
         var table_id ="#tbl_appraisal_details";
        var employee_id = $("#appraisal_employee_id").val();
        var status = $("#appraisal_status").val();
        var branch_id = $("#appraisal_branch_id").val();
         var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/appraisalemployee/GetAppraisalList') . '",
                type: "POST",
                data : {
                    "status" : status,"employee_id":employee_id,"branch_id" : branch_id                 
                },
                cache : false,
            },
            columnDefs: [
                { "bSortable": false, "aTargets": [9] },
            ],
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        });
        $(".dataTables_scrollFoot").hide();
    }
    $(document).ready(function() {  		
        filterDataTable();
    })', CClientScript::POS_HEAD);
$cs->registerScript("appraisaldetails", "function appraisaldetails(){  
    $('#tbl_appraisal_details').DataTable().destroy();
    filterDataTable();  
};", CClientScript::POS_HEAD);
$cs->registerScript("deleteappraisaldetail", "function deleteappraisaldetail(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {	
            jQuery.ajax({
                'type'      : 'post',
                'data'      : 'id=' + id,
                'dataType'  : 'json',  
                'url'       : $('#liveSite').val()+'index.php?r=hr/appraisalemployee/deleteappraisaldetail',
                'cache'     : false,
                'success'   :function(data){
                    if(data.status=='success'){
                        t8.success('Deleted SuccessFully!');
                        reloadTable('#tbl_appraisal_details');
                    }else {
                        t8.error('Error while Delete');
                    }
               }
            });
        }
};", CClientScript::POS_HEAD);
?>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-plus"></i> Appraisal Objectives
        <div class="pull-right">
            <?php echo CHtml::dropDownList("appraisal_employee_id",'',Employee::getEmployee($branch), array( 'empty' => 'Select Employee', 'title' => 'Employee Name','data-label'=>'Employee Name','data-search'=>true,'class'=>'col-sm-4 form-control_1','onchange'=>'appraisaldetails();')); ?>                           
            <?php
                $dropdown_list=array();
                $model_approval_status=HrEmployeeApproveLevel::model()->with('employeedetail')->find(array('select'=>'max(max_level) as max_level','condition' =>'employeedetail.branch_or_sponsor_id="'.$branch.'" and functionality_id="6"'));
                if(!empty($model_approval_status)){
                    $max_level=$model_approval_status->max_level;
                }
                $selected='H';
                $dropdown_list=array(
                        -3 => "Added",
                        -2 => "Employee Objective Confirmation",
                        -1 => "Line Manager Objective Confirmation",
                    );
                
                echo CHtml::dropdownlist('appraisal_status',$selected,$dropdown_list,  array('class'=>'col-sm-4 form-control_1','title' => 'Please select Status','empty'=>'All','onchange'=>'appraisaldetails()')); 
                ?>
            <input type="hidden" id="appraisal_branch_id" name="appraisal_branch_id" value="<?php echo  $branch; ?>"/>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['appraisal_questions_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('hr/appraisalemployee/create&branch=<?php echo $branch; ?>','Add Appraisal Objective','xl')"><i class="fa fa-plus"></i> ADD</button>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_appraisal_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Department</th>
                        <th>Designation</th>
                        <th>Joining Date</th>
                        <th>Appraisal For</th>
                        <th>Created Date</th>
                        <th>Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
