<?php 
    $model_setting = HrGenerelSettings::model()->find();
    $current_month = date("m");
    $year = date("Y");
    if ($current_month > $model_setting->leave_carry_forward_month) {
        $year = $year + 1;
    }
    $leave_date = $year . '-' . $model_setting->leave_carry_forward_month . '-01';
    $achieved_date = date('d/m/Y', strtotime('-1 days', strtotime($leave_date))); 
?>
<table class="table table-hover table-bordered personal-task" id="type_item_table">
    <tr>
        <th>No</th> 
        <th>Goal</th> 
        <th>Weightage</th>
    </tr>
    <?php
    foreach ($model_type as $i => $details):
        ?>
        <tr>
            <td><label><?php echo ($i + 1); ?></label></td> 
            <td>
                <?php echo CHtml::activeHiddenField($model_Type, "[" . $i . "]id"); ?>
                <?php  echo $details->typedetail->appraisal_type;
                $model_Type->type_id=$details->appraisal_type;
                echo CHtml::activeHiddenField($model_Type, "[" . $i . "]type_id"); ?>                           
            </td>
            <td>
                <?php  
                $model_Type->weightage=$details->typedetail->default_weightage;
                echo CHtml::activetextField($model_Type, "[" . $i . "]weightage",array('class'=>'tooltipster go', 'placeholder' => 'Weightage', 'title' => 'Weightage')); ?>                           
            </td>            
        </tr>
    <?php endforeach; ?>
</table>
<div class="" style="margin-bottom: 120px">
<table class="table table-hover table-bordered personal-task" id="questions_item_table">
    <tr>
        <th>No</th> 
        <th>Goal</th> 
        <th>KPI</th>
        <th>Weightage</th> 
        <th>Date <?php echo CHtml::textField("achieved_date", $achieved_date, array('class' => 'datepicker targetdate form-control', 'onkeypress' => 'return false;')); ?>
</th> 
        <th></th>
    </tr>
    <?php
    foreach ($model_questions as $i => $detail):
        ?>
        <tr>
            <td><label><?php echo ($i + 1); ?></label></td> 
            <td>
                <?php  
                $model_analysis->appraisal_type=$detail->appraisal_type;
                echo $detail->typedetail->appraisal_type; 
                echo CHtml::activeHiddenField($model_analysis, "[" . $i . "]appraisal_type");?>                           
            </td>
            <td>
                <?php echo CHtml::activeHiddenField($model_analysis, "[" . $i . "]id"); ?>
                <?php echo CHtml::activeHiddenField($model_analysis, "[" . $i . "]question_id", array('value' => $detail->id)); ?>
                <?php echo CHtml::activeHiddenField($model_analysis, "[" . $i . "]appraisal_goal", array('value' => $detail->typedetail->appraisal_type)); ?>
                <?php echo CHtml::activeTextArea($model_analysis, "[" . $i . "]question", array('value' => $detail->question, 'class' => 'tooltipster go', 'placeholder' => 'KPI', 'title' => 'KPI','readonly'=>true)); ?>                           
            </td>
            <td>
                <?php  
                $model_analysis->question_weightage=$detail->weightage_percent;
                echo CHtml::activetextField($model_analysis, "[" . $i . "]question_weightage",array('class'=>'tooltipster go', 'placeholder' => 'Weightage', 'title' => 'Weightage')); ?>                           
            </td>
            <td>
                <?php
                $model_analysis->target_achieved_date = $achieved_date;
                echo CHtml::activetextField($model_analysis, "[" . $i . "]target_achieved_date", array('class' => 'datepicker form-control achieveddate', 'onkeypress' => 'return false;'));
                ?>                           
            </td>   
            <td class="text-center nw" width="1%">
                       <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','id'=>$i,'onclick' => 'removeitemRow($(\'#questions_item_table\'),this,this.id)
                                           ', 'title' => 'Remove this item')); ?>
            </td>
        </tr>
    <?php endforeach; ?>
</table>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("removeitemRow", "function removeitemRow(jQtable,evt,field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    var id=$('#HrAppraisalAnalysis_'+arr_fields+'_id').val();
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var num_rows    =   jQtable.find('tr:gt(0)').length;
    if(num_rows>1){
        var tr  =   $(evt).parent().parent();
        if(isRowEmpty(tr)) {
            if(id!=''){
                jQuery.ajax({
                    'type': 'post',
                    'dataType': 'json',
                    'url': '" . Yii::app()->createUrl('hr/appraisal/deletelineitem') . "',
                    'data': {'id':id}  ,
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            $(evt).parents('tr').remove();
                            var i=0;
                            jQtable.find('tr:gt(0)').each(function() {
                                $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                                {
                                    old_id   =   $(this).attr('id');
                                    if(old_id!==undefined) {
                                        new_id   =   old_id.replace(/\d+/,i);
                                        $(this).attr('id',new_id);
                                    }
                                    old_name =   $(this).attr('name');
                                    if(old_name!==undefined) {
                                        new_name =   old_name.replace(/\d+/,i);
                                        $(this).attr('name',new_name);
                                    }
                                });
                                $(this).find('td:first label').html(++i);
                            });
                            t8.success('Question Deleted');
                            reloadTable('#tbl_question_details');
                        }else{
                            t8.error('Deletion Not Possible, History Exist');
                        }
                    }
                });
            }else{
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() {
                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        if(old_id!==undefined) {
                            new_id   =   old_id.replace(/\d+/,i);
                            $(this).attr('id',new_id);
                        }
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        }
                    });
                    $(this).find('td:first label').html(++i);
                });
            }
        }
    }else {
        alert('Atleast one item needed here');
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("setaciveddate", "
    $('#achieved_date').datetimepicker({format: 'DD/MM/YYYY'}).on('dp.hide', function (e) {
        var target_date=$('#achieved_date').val(); 
        $('.achieveddate').val(target_date); 
       });", CClientScript::POS_HEAD);
$cs->registerScript("readyfunc", "$(document).ready(function() {
    $('.achieveddate,targetdate').datetimepicker({
        format: 'DD/MM/YYYY',
        widgetPositioning: {
              horizontal: 'auto', // set to 'auto' for default positioning
              vertical: 'bottom' // set to 'top' or 'bottom' as per your requirement
            }                   
    }); 
});", CClientScript::POS_HEAD);