<?php

/**
 * This is the model class for table "view_leave_details".
 *
 * The followings are the available columns in table 'view_leave_details':
 * @property integer $employee_id
 * @property string $first_name
 * @property string $last_name
 * @property string $employee_code
 * @property integer $id
 * @property string $apply_date
 * @property string $leave_start_date
 * @property string $leave_end_date
 * @property integer $leave_type
 * @property string $no_days
 * @property string $leave_status
 * @property string $leave_approval_document
 * @property string $type
 */
class ViewLeaveDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'view_leave_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, id, leave_type', 'numerical', 'integerOnly'=>true),
			array('first_name, last_name, employee_code', 'length', 'max'=>500),
			array('no_days', 'length', 'max'=>5),
			array('leave_status', 'length', 'max'=>11),
			array('leave_approval_document', 'length', 'max'=>255),
			array('type', 'length', 'max'=>15),
			array('apply_date, leave_start_date, leave_end_date', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('employee_id, first_name, last_name, employee_code, id, apply_date, leave_start_date, leave_end_date, leave_type, no_days, leave_status, leave_approval_document, type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
                    'leavetype' => array(self::BELONGS_TO, 'MasLeave', 'leave_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'employee_id' => 'Employee',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'employee_code' => 'Employee Code',
			'id' => 'ID',
			'apply_date' => 'Apply Date',
			'leave_start_date' => 'Leave Start Date',
			'leave_end_date' => 'Leave End Date',
			'leave_type' => 'Leave Type',
			'no_days' => 'No Days',
			'leave_status' => 'Leave Status',
			'leave_approval_document' => 'Leave Approval Document',
			'type' => 'Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('employee_code',$this->employee_code,true);
		$criteria->compare('id',$this->id);
		$criteria->compare('apply_date',$this->apply_date,true);
		$criteria->compare('leave_start_date',$this->leave_start_date,true);
		$criteria->compare('leave_end_date',$this->leave_end_date,true);
		$criteria->compare('leave_type',$this->leave_type);
		$criteria->compare('no_days',$this->no_days,true);
		$criteria->compare('leave_status',$this->leave_status,true);
		$criteria->compare('leave_approval_document',$this->leave_approval_document,true);
		$criteria->compare('type',$this->type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ViewLeaveDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
