<?php

/**
 * This is the model class for table "{{hr_salary_slip_details}}".
 *
 * The followings are the available columns in table '{{hr_salary_slip_details}}':
 * @property integer $id
 * @property integer $salary_slip_id
 * @property integer $salary_id
 * @property integer $salary_type
 * @property string $salary_name
 * @property string $salary_amount
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class SalarySlipDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_salary_slip_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('salary_slip_id,salary_processing_id, salary_id, salary_type, salary_name, salary_amount', 'required'),
			array('salary_slip_id,salary_processing_id, salary_id, salary_type, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('salary_name', 'length', 'max'=>255),
			array('salary_amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, salary_slip_id, salary_id, salary_type, salary_name, salary_amount, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'salaryslip' => array(self::BELONGS_TO, 'SalarySlip', 'salary_slip_id'),
                    'processing' => array(self::BELONGS_TO, 'SalaryProcessing', 'salary_processing_id'),
                    'salarymaster' => array(self::BELONGS_TO, 'MasSalarytype', 'salary_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'salary_slip_id' => 'Salary Slip',
			'salary_id' => 'Salary',
			'salary_type' => 'Salary Type',
			'salary_name' => 'Salary Name',
			'salary_amount' => 'Salary Amount',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('salary_slip_id',$this->salary_slip_id);
		$criteria->compare('salary_id',$this->salary_id);
		$criteria->compare('salary_type',$this->salary_type);
		$criteria->compare('salary_name',$this->salary_name,true);
		$criteria->compare('salary_amount',$this->salary_amount,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SalarySlipDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
