<?php

/**
 * This is the model class for table "{{hr_salary_processing}}".
 *
 * The followings are the available columns in table '{{hr_salary_processing}}':
 * @property integer $id
 * @property integer $payroll_branch_or_sponsor_id
 * @property string $payroll_startdate
 * @property string $payroll_enddate
 * @property string $payroll_month
 * @property integer $payroll_status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class SalaryProcessing extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_salary_processing}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('payroll_branch_or_sponsor_id,payroll_startdate, payroll_enddate, payroll_month, payroll_status', 'required'),
            array('payroll_branch_or_sponsor_id, payroll_status, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('payroll_month', 'length', 'max' => 255),
            array('isActive', 'length', 'max' => 1),
            array('payroll_branch_or_sponsor_id', 'validatesalarymonthbranch','on'=>'calculate'), //added on 9/8/2022 by DIkson R
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, payroll_branch_or_sponsor_id, payroll_startdate, payroll_enddate, payroll_month, payroll_status, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'branch_sponsor' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'payroll_branch_or_sponsor_id'),
            'items' => array(self::HAS_MANY, 'SalarySlip', 'salary_processing_id', 'order' => 'items.id asc'),
            'userdetails' => array(self::BELONGS_TO, 'User', 'created_by'),
        );
    }

    public function validatesalarymonthbranch() {

        if ($this->payroll_branch_or_sponsor_id != '' && $this->payroll_startdate != '' && $this->payroll_enddate != '') {
            $condition = 'payroll_branch_or_sponsor_id="' . $this->payroll_branch_or_sponsor_id . '" and payroll_startdate="' . $this->payroll_startdate . '"  and payroll_enddate="' . $this->payroll_enddate . '"';
            $model = self::model()->find(array('condition' => $condition));
            if (!empty($model) && $model->id > 0) {
                $this->addError('payroll_branch_or_sponsor_id', 'Salary already Calculated for this month by ' . $model->userdetails->Fullname);
                return false;
            } else {
                return true;
            }
        }
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'payroll_branch_or_sponsor_id' => 'Payroll Branch Or Sponsor',
            'payroll_startdate' => 'Payroll Startdate',
            'payroll_enddate' => 'Payroll Enddate',
            'payroll_month' => 'Payroll Month',
            'payroll_status' => '1-unlock,2-lock',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('payroll_branch_or_sponsor_id', $this->payroll_branch_or_sponsor_id);
        $criteria->compare('payroll_startdate', $this->payroll_startdate, true);
        $criteria->compare('payroll_enddate', $this->payroll_enddate, true);
        $criteria->compare('payroll_month', $this->payroll_month, true);
        $criteria->compare('payroll_status', $this->payroll_status);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);
        $criteria->compare('isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return SalaryProcessing the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getday($weekvalue) {
        if ($weekvalue == 1) {
            $day = "Sun";
        } else if ($weekvalue == 2) {
            $day = "Mon";
        } else if ($weekvalue == 3) {
            $day = "Tue";
        } else if ($weekvalue == 4) {
            $day = "Wed";
        } else if ($weekvalue == 5) {
            $day = "Thu";
        } else if ($weekvalue == 6) {
            $day = "Fri";
        } else if ($weekvalue == 7) {
            $day = "Sat";
        }
        return $day;
    }

    public function getMonth() {
        $branch = "All branches";
        if ($this->payroll_branch_or_sponsor_id > 0) {
            $branch = $this->branch_sponsor->branch_or_sponsor_name;
        }
        return ($this->payroll_month . '-' . date('Y', strtotime($this->payroll_enddate)) . '-' . $branch);
    }

    public static function getMonthsalaryslip() {
        $arr_sal = array();
        $model_user = User::model()->findByPK(Yii::app()->user->id);
        $model_usergroup = MasUserGroup::model()->find(array('condition' => 'id="' . $model_user->user_group_id . '"'));
        $branch_id = 0;
        if ($model_usergroup->salary_tab_permission != '') {
            $branch_id = $model_usergroup->salary_tab_permission;
        }
        if (Yii::app()->user->authorised_user == 1) {
            $condition = 't.payroll_status="2"';
        } else {
            $condition = 't.payroll_status="2" AND payroll_branch_or_sponsor_id IN(' . $branch_id . ')';
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'payroll_enddate desc'));
        $arr_sal = CHtml::listData($model, 'id', 'Month');
        return $arr_sal;
    }
    public static function getMonthsalaryslipen() {
        $arr_list=array();
        $model_user = User::model()->findByPK(Yii::app()->user->id);
        $model_usergroup = MasUserGroup::model()->find(array('condition' => 'id="' . $model_user->user_group_id . '"'));
        $branch_id = 0;
        if ($model_usergroup->salary_tab_permission != '') {
            $branch_id = $model_usergroup->salary_tab_permission;
        }
        if (Yii::app()->user->authorised_user == 1) {
            $condition = 't.payroll_status="2"';
        } else {
            $condition = 't.payroll_status="2" AND payroll_branch_or_sponsor_id IN(' . $branch_id . ')';
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'payroll_enddate desc'));
        foreach ($model as $key => $value) {
            $arr_list[$key]['id']=Yii::app()->controller->ciphertext($value->id,"e");
            $arr_list[$key]['Month']=$value->Month;
        }
        return CHtml::listData($arr_list, 'id', 'Month');
    }
    public static function getunlockMonthsalary() {
        $arr_sal = array();
        $model = self::model()->findAll(array('condition' => 'payroll_status="1"', 'order' => 'id desc'));
        $arr_sal = CHtml::listData($model, 'id', 'Month');
        return $arr_sal;
    }
    public static function getMonthsalaryslippreviewen() {
        $arr_list=array();
        $model_user = User::model()->findByPK(Yii::app()->user->id);
        $model_usergroup = MasUserGroup::model()->find(array('condition' => 'id="' . $model_user->user_group_id . '"'));
        $branch_id = 0;
        if ($model_usergroup->salary_tab_permission != '') {
            $branch_id = $model_usergroup->salary_tab_permission;
        }
        if (Yii::app()->user->authorised_user == 1) {
            $condition = 't.payroll_status="1"';
        } else {
            $condition = 't.payroll_status="1" AND payroll_branch_or_sponsor_id IN(' . $branch_id . ')';
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'payroll_enddate desc'));
        foreach ($model as $key => $value) {
            $arr_list[$key]['id']=Yii::app()->controller->ciphertext($value->id,"e");
            $arr_list[$key]['Month']=$value->Month;
        }
        return CHtml::listData($arr_list, 'id', 'Month');
    }

}
