<?php

/**
 * This is the model class for table "{{hr_room_bedspace}}".
 *
 * The followings are the available columns in table '{{hr_room_bedspace}}':
 * @property integer $id
 * @property integer $building_floor_id
 * @property integer $room_id
 * @property string $bed_space_name
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class RoomBedspace extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_room_bedspace}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('building_floor_id, room_id, bed_space_name', 'required'),
			array('building_floor_id, room_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('bed_space_name', 'length', 'max'=>500),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, building_floor_id, room_id, bed_space_name, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'buildingdetail' => array(self::BELONGS_TO, 'RoomSetting', 'building_floor_id'),
                    'roomdetail' => array(self::BELONGS_TO, 'RoomSettingDetails', 'room_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'building_floor_id' => 'Building Floor',
			'room_id' => 'Room',
			'bed_space_name' => 'Bed Space Name',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('building_floor_id',$this->building_floor_id);
		$criteria->compare('room_id',$this->room_id);
		$criteria->compare('bed_space_name',$this->bed_space_name,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RoomBedspace the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getbedspacedetail($room_id) {
            $SQL ="SELECT * FROM  `erp_hr_room_bedspace`  WHERE room_id='".$room_id."' and isActive='Y'  && id NOT IN (SELECT  bedspace_id FROM  erp_hr_room_allocation) ORDER BY bed_space_name ASC";                               
            $model = Yii::app()->db->createCommand($SQL)->queryAll(); 
            return CHtml::listData($model, 'id', 'bed_space_name');
        }
}
