<?php

/**
 * This is the model class for table "{{hr_room_allocation}}".
 *
 * The followings are the available columns in table '{{hr_room_allocation}}':
 * @property integer $id
 * @property integer $building_id
 * @property integer $room_id
 * @property integer $bedspace_id
 * @property integer $employee_id
 * @property string $start_date
 * @property string $end_date
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class RoomAllocation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_room_allocation}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('building_id, room_id, employee_id, start_date', 'required'),
			array('building_id, room_id, bedspace_id, employee_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, building_id, room_id, bedspace_id, employee_id, start_date, end_date, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'buildingdetail' => array(self::BELONGS_TO, 'RoomSetting', 'building_id'),
                    'roomdetail' => array(self::BELONGS_TO, 'RoomSettingDetails', 'room_id'),
                    'bedspacedetail' => array(self::BELONGS_TO, 'RoomBedspace', 'bedspace_id'),
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'building_id' => 'Building',
			'room_id' => 'Room',
			'bedspace_id' => 'Bedspace',
			'employee_id' => 'Employee',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('room_id',$this->room_id);
		$criteria->compare('bedspace_id',$this->bedspace_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RoomAllocation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getemployee() {
            $SQL ="SELECT * FROM  `erp_hr_employee`  WHERE isActive='Y'  && id NOT IN (SELECT employee_id FROM  erp_hr_room_allocation where end_date!='0000-00-00')";                               
            $model = Yii::app()->db->createCommand($SQL)->queryAll(); 
            $arr_employee = array();
            $employee_details = array();
            foreach ($model as $value) {
                $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d")] = $value['id'];
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
            return CHtml::listData($employee_details, 'id', 'name');
        }
}
