<?php

/**
 * This is the model class for table "{{hr_master_mail_detail}}".
 *
 * The followings are the available columns in table '{{hr_master_mail_detail}}':
 * @property integer $id
 * @property string $mail_function_type
 * @property string $isActive
 */
class MasterMailDetail extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_master_mail_detail}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('mail_function_type', 'required'),
			array('mail_function_type', 'length', 'max'=>500),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, mail_function_type, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'maildetail' => array(self::HAS_MANY, 'MailSettings', 'mail_function'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'mail_function_type' => 'Mail Function Type',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('mail_function_type',$this->mail_function_type,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasterMailDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getMailfunctionality() {
           $condition = 't.isActive =  "Y"';
           $model = self::model()->findAll(array('condition' => $condition,'order'=>'mail_function_type asc'));
           return CHtml::listData($model, 'id', 'mail_function_type');
        }
        public static function getMailfunction() {
            $SQL ="SELECT * FROM  `erp_hr_master_mail_detail`  WHERE isActive='Y'  && id NOT IN (SELECT  mail_function FROM  erp_hr_mail_settings) ORDER BY mail_function_type ASC";                               
            $model = Yii::app()->db->createCommand($SQL)->queryAll(); 
            return CHtml::listData($model, 'id', 'mail_function_type');
        }
}
