<?php

/**
 * This is the model class for table "{{mas_salarytype}}".
 *
 * The followings are the available columns in table '{{mas_salarytype}}':
 * @property integer $id
 * @property string $department_name
 * @property string $isActive
 *
 * The followings are the available model relations:

 */
class MasSalarytype extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_mas_salarytype}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('salary_name,salary_type,editable', 'required'),
            array('salary_name', 'length', 'max' => 255),
            array('salary_type,salary_occurence', 'numerical', 'integerOnly' => true),
            array('salary_name', 'filter', 'filter'=>'trim'),
            array('salary_name', 'unique'),
            //array('salary_name', 'unique', 'on' => 'add'),
            array('consider_deduction,consider_leave_settlement,isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, salary_name,salary_type,salary_occurence, isActive', 'safe', 'on' => 'search'),
        );
    }
    function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 23;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' salary type '.$this->salary_name;
        $model_audit_log->save();
    }


    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
      
         'salary' => array(self::BELONGS_TO, 'MasSalarytype', 'salary_type'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'salary_name' => 'Name',
              'salary_type' => 'Type',
              'salary_occurence' => 'Occurence',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria = new CDbCriteria;
//        $searchterm = trim(Yii::app()->request->getParam('salary_name'));
       $sterm = trim(Yii::app()->request->getParam('search'));
       $sterm_type = trim(Yii::app()->request->getParam('search_type'));
        if($sterm)
        {
        $criteria->addCondition('salary_name like "%' . $sterm . '%"', 'AND');
        }
        if($sterm_type)
        {
        $criteria->addCondition('salary_type like "%' . $sterm_type . '%"', 'AND');
        }
//        if (!empty($searchterm)){
//            $criteria->addCondition('salary_name like "%' . $searchterm . '%"', 'AND');
//        }
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 12,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.salary_name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return  the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }


    public static function getSalartype() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'salary_name');
    }
    public static function getAdditionwithrecurring() {
        $condition = 'isActive =  "Y" and salary_type="1" and editable="1"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'salary_name');
    }
    
    public static function getFiiledSalarytypeName($id) {
        $model = self::model()->findByPk($id);
        return $model->salary_name;
    }
    
    public static function getSalaryTypeByOccurance($type=0) {
    	
    	$condition = 'isActive =  "Y" AND salary_occurence="1"';
    	if($type!=0)
    	{
    		$condition.= ' AND salary_type='.$type;
    	}
    	
    	$model = self::model()->findAll(array('condition' => $condition));
    	return CHtml::listData($model, 'id', 'salary_name');
    }
     public static function getSalaryTypeByOccuranc($type=0) {
    	
    	$condition = 'isActive =  "Y" AND salary_occurence="1"';
    	if($type!=0)
    	{
    		$condition.= ' AND salary_type='.$type;
    	}
    	
    	$model = self::model()->findAll(array('condition' => $condition));
    	return CHtml::listData($model, 'salary_name', 'salary_name');
    }
    public static function getSalarytype() {
        $condition = 'isActive =  "Y" and salary_occurence="2"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'salary_name');
    }
    public static function getSalarytypefixed() {
        $condition = 'isActive =  "Y" and salary_occurence="2" AND salary_type="1"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'salary_name');
    }
}
