<?php

/**
 * This is the model class for table "{{mas_salarytype}}".
 *
 * The followings are the available columns in table '{{mas_salarytype}}':
 * @property integer $id
 * @property string $department_name
 * @property string $isActive
 *
 * The followings are the available model relations:

 */
class MasOverTime extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_mas_over_time}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('type,salary,times', 'required'),
            array('type', 'length', 'max' => 255),
            array('type', 'unique', 'on' => 'add'),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, type,salary,times, isActive', 'safe', 'on' => 'search'),
        );
    }
    function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 36;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' overtime type  '.$this->type;
        $model_audit_log->save();
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'salarytype' => array(self::BELONGS_TO, 'MasSalarytype', 'salary'),

         
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'type' => 'Type',
            'salary' => 'Salary',
            'times' => 'Times',
            'isActive' => 'is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria = new CDbCriteria;
//        $searchterm = trim(Yii::app()->request->getParam('salary_name'));
       $sterm = trim(Yii::app()->request->getParam('search'));
     
        if($sterm)
        {
        $criteria->addCondition('type like "%' . $sterm . '%"', 'AND');
        }
//        if (!empty($searchterm)){
//            $criteria->addCondition('salary_name like "%' . $searchterm . '%"', 'AND');
//        }
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 12,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return  the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

 public static function getType()
        {
               $condition = 'isActive =  "Y"';
        $model = MasSalarytype::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'salary_name');
        }
   public static function getOverTime()
        {
               $condition = 'isActive =  "Y"';
        $model = MasOverTime::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'type');
        }
    public static function gettypetimes() {
        return ($this->type . ' - ' . $this->times);
    }
        public static function getOverTimeType()
        {
        $condition = 'isActive =  "Y"';
        $model = MasOverTime::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'typetimes');
        }
}
