<?php

/**
 * This is the model class for table "{{mas_gratuity}}".
 *
 * The followings are the available columns in table '{{mas_gratuity}}':
 * @property integer $id
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class MasLeave extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_mas_leave}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('leave_name,leave_abbreviation,leave_type,leave_days,branch_id,leave_days_above_1,leave_days_above_5,leave_days_above_10', 'required'),
            array('leave_name,leave_abbreviation', 'length', 'max' => 255),
            array('parent_id,carry_forward_leave,gender,employee_can_apply,min_day_upload', 'numerical', 'integerOnly'=>true),
            array('leave_abbreviation', 'length', 'max' => 3),
            //array('leave_name', 'unique', 'on' => 'add'),
            //array('leave_abbreviation', 'unique'),
            array('leave_name', 'validateleavename'),
            array('ticket_increment_hold_on_leave,leave_increment_hold_on_leave,show_app_dashboard,is_annual_leave,visible_portal,encashable,carry_forward,ticket_available,document_medical_certificate_upload,salary_deduction,show_in_payslip,isActive,leave_count_employee_panel,carry_forward_limit,exclude_weekend,exclude_holiday', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,leave_name,employee_id,leave_days,carry_forward, isActive', 'safe', 'on' => 'search'),
        );
    }
    function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 34;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' leave type  '.$this->leave_name;
        $model_audit_log->save();
    }

    public function validateleavename() {

        if ($this->leave_name == '') {
            $this->addError('leave_name', 'Enter Leave Name');
            return false;
        }else if ($this->leave_name!= '' && $this->leave_abbreviation!='' && $this->branch_id!='') {
            $condition='branch_id="'.$this->branch_id.'" and leave_name="'.$this->leave_name.'" and leave_abbreviation="'.$this->leave_abbreviation.'"';
            if($this->id!=''){
                $condition.=' AND id!="'.$this->id.'"';
            }
            $model = self::model()->find(array('condition'=>$condition));
            if(!empty($model) && $model->id>0){
                $this->addError('leave_name', 'Leave already exist for this branch');
                return false;
            }else{
                return true;
            }
        }
        
    }
    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'branch' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch_id'),
          
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'leave_name'=>'Name',
            'leave_abbreviation'=>'Abbreviation',
            'leave_days'=>'No of days',
            'leave_days_above_5'=>'Enter Leave Days for Employee above 5 Yrs',
            'leave_days_above_1'=>'Enter Leave Days for Employee above 1 Yrs',
            'encashable'=>'Encashable',
            'carry_forward'=>'Carry Forward',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
     /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return  the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

  public function getleavewithbranchname() {
        return ($this->leave_name. '(' . $this->branch->branch_or_sponsor_name. ' )');
    }

    public static function getLeave($branch_id = 0) {
        $condition = 'isActive =  "Y"';
        if ($branch_id > 0) {
            $condition.=' AND branch_id="' . $branch_id . '"';
        }
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'leavewithbranchname');
    }
    public static function getLeavebybranchname($branch_id = 0) {
        $condition = 'isActive =  "Y" AND salary_deduction!="N"';
        if ($branch_id > 0) {
            $condition.=' AND branch_id="' . $branch_id . '"';
        }
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'leavewithbranchname');
    }
    public static function getParentLeave($branch_id = 0) {
        $condition = 'isActive =  "Y" and sub_type_leave="N"';
        if ($branch_id > 0) {
            $condition.=' AND branch_id="' . $branch_id . '"';
        }
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'leave_name');
    }
    public static function getLeavebytype($branch_id = 0) {
        $condition = 'isActive =  "Y" and leave_count_employee_panel="Y" and sub_type_leave="N"';
        if ($branch_id > 0) {
            $condition.=' AND branch_id="' . $branch_id . '"';
        }
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'leave_name');
    }
    public static function getLeavebyemployee($id=0) {
        $condition = 'isActive =  "Y" and FIND_IN_SET('.$id.', employee_id)';
        $model_master_employee = Employee::model()->findbypk($id);
        $gender=$model_master_employee->gender;
        $service_days=0;
        if(!empty($model_master_employee)){
            if($model_master_employee->date_join!='' && $model_master_employee->date_join!="0000-00-00"){
                $d1 = strtotime($model_master_employee->date_join);
                $d2 = strtotime(date('Y-m-d'));
                $datediff = $d2 - $d1;
                $service_days = $datediff / (60 * 60 * 24)+1;
            }
            $condition.=' AND branch_id="' . $model_master_employee->branch_or_sponsor_id . '"';
        }
        $condition.= ' AND (employee_can_apply="0" OR employee_can_apply<="'.$service_days.'") AND (gender=0 OR gender="'.$gender.'")';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'leave_name');
    }
    public static function getEncashableleavetype($employee_id=0) {
        $condition = 'isActive =  "Y" and encashable="Y"';
        if($employee_id>0){
            $model_employee = Employee::model()->findbyPk($employee_id);
            $condition.=' AND branch_id="' . $model_employee->branch_or_sponsor_id . '"';
        }
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'leave_name');
    }
    public static function getticketleavetype($branch_id = 0) {
        $condition = 'isActive =  "Y" and ticket_available="Y" AND branch_id="' . $branch_id . '"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'leave_name');
    }
    public static function getLeavebybranchnameformultiselect($branch_id = 0) {
        $condition = 'isActive =  "Y" ';
        if ($branch_id !='' && $branch_id !='null') {
            $condition.=' AND branch_id IN(' . $branch_id . ')';
        }
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'leavewithbranchname');
    }
}
