<?php

/**
 * This is the model class for table "{{mas_department}}".
 *
 * The followings are the available columns in table '{{mas_department}}':
 * @property integer $id
 * @property string $department_name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class MasDepartment extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_department}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('department_name', 'required'),
            array('department_name', 'length', 'max' => 255),
            array('department_name', 'unique'),
            array('department_name', 'filter', 'filter'=>'trim'),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, department_name, isActive', 'safe', 'on' => 'search'),
        );
    }
    function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 1;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' department '.$this->department_name;
        $model_audit_log->save();
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'department_name' => 'Department',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('department_name'));
       $sterm = trim(Yii::app()->request->getParam('search'));
     
        if($sterm)
        {
        $criteria->addCondition('department_name like "%' . $sterm . '%"', 'AND');
        }
        if (!empty($searchterm)){
            $criteria->addCondition('department_name like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 12,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.department_name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBank the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }



    public static function getDepartment() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'department_name asc'));
        return CHtml::listData($model, 'id', 'department_name');
    }
    public static function getDepartmentName() {
        $condition = 'isActive =  "Y" ';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'department_name asc'));
        return CHtml::listData($model, 'id', 'department_name');
    }

    public static function getFiiledDepartmentName($id) {
        $model = self::model()->findByPk($id);
        return $model->department_name;
    }
 

 
}
