<?php

/**
 * This is the model class for table "{{mas_branch_or_sponsor_branch}}".
 *
 * The followings are the available columns in table '{{mas_branch_or_sponsor_branch}}':
 * @property string $id
 * @property string $branch_or_sponsor_logo
 * @property string $branch_or_sponsor_name
 * @property string $branch_or_sponsor_address
 * @property string $branch_or_sponsor_city
 * @property string $branch_or_sponsor_postalcode
 * @property string $branch_or_sponsor_state
 * @property string $branch_or_sponsor_country
 * @property integer $branch_or_sponsor_currency_id
 * @property string $isActive
 */
class MasCompanyBranchSponsor extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $branch_head_name;
    public $currency_name;

    public function tableName() {
        return '{{hr_mas_company_branch_sponsor}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('branch_or_sponsor_name, branch_or_sponsor_address,branch_or_sponsor_country,branch_or_sponsor_currency_id,hr_code,slip_header_name,branch_or_sponsor_code', 'required'),
            array('branch_or_sponsor_currency_id,exclude_weekend', 'numerical', 'integerOnly' => true),
            array('branch_or_sponsor_logo, branch_or_sponsor_name, branch_or_sponsor_city, branch_or_sponsor_postalcode, branch_or_sponsor_state,
                   branch_or_sponsor_phno, branch_or_sponsor_email, branch_or_sponsor_location,branch_or_sponsor_fax, branch_or_sponsor_web', 'length', 'max' => 255),
            array('leave_encashment_provided,leave_settlement_provided,ticket_provided,ticket_monthly_incremented,ticket_carry_forward,isActive', 'length', 'max' => 1),
            array('branch_or_sponsor_name', 'unique', 'message' => 'Branch Name {value} already exist'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('branch_or_sponsor_logo,workstart_time,workend_time,branch_or_sponsor_name,branch_or_sponsor_address, branch_or_sponsor_city, branch_or_sponsor_state, 
                  branch_or_sponsor_country, branch_or_sponsor_postalcode,branch_or_sponsor_phno, branch_or_sponsor_email, branch_or_sponsor_location, 
                  branch_or_sponsor_fax, branch_or_sponsor_web, branch_or_sponsor_currency_id, organization_chart_name, isActive', 'safe', 'on' => 'search'),
        );
    }

    function afterSave() {
        $action_type = '';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 32;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks = $action_type . ' branch  ' . $this->branch_or_sponsor_name;
        $model_audit_log->save();
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'baseCurrency' => array(self::BELONGS_TO, 'MasCurrency', 'branch_or_sponsor_currency_id'),
            'branchhead' => array(self::BELONGS_TO, 'User', 'branch_head_id'),
            'country' => array(self::BELONGS_TO, 'MasCountry', 'branch_or_sponsor_country'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'branch_or_sponsor_logo' => 'Company Logo',
            'branch_or_sponsor_name' => 'Company Name',
            'branch_or_sponsor_address' => 'Address',
            'branch_or_sponsor_city' => 'City',
            'branch_or_sponsor_state' => 'State',
            'branch_or_sponsor_country' => 'Country',
            'branch_or_sponsor_postalcode' => 'Postalcode',
            'branch_or_sponsor_phno' => 'Phone Number',
            'branch_or_sponsor_email' => 'Email',
            'branch_or_sponsor_location' => 'Location',
            'branch_or_sponsor_fax' => 'Fax',
            'branch_or_sponsor_web' => 'Web',
            'branch_or_sponsor_currency_id' => 'Currency',
            'organization_chart_name' => 'Organization Chart Name',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);

        $criteria->compare('id', $this->id, true);
        $criteria->compare('branch_or_sponsor_logo', $this->branch_or_sponsor_logo, true);
        $criteria->compare('branch_or_sponsor_name', $this->branch_or_sponsor_name, true);
        $criteria->compare('branch_or_sponsor_address', $this->branch_or_sponsor_address, true);
        $criteria->compare('branch_or_sponsor_city', $this->branch_or_sponsor_city, true);
        $criteria->compare('branch_or_sponsor_state', $this->branch_or_sponsor_state, true);
        $criteria->compare('branch_or_sponsor_country', $this->branch_or_sponsor_country, true);
        $criteria->compare('branch_or_sponsor_postalcode', $this->branch_or_sponsor_postalcode, true);
        $criteria->compare('branch_or_sponsor_phno', $this->branch_or_sponsor_phno, true);
        $criteria->compare('branch_or_sponsor_email', $this->branch_or_sponsor_email, true);
        $criteria->compare('branch_or_sponsor_location', $this->branch_or_sponsor_location, true);
        $criteria->compare('branch_or_sponsor_fax', $this->branch_or_sponsor_fax, true);
        $criteria->compare('branch_or_sponsor_web', $this->branch_or_sponsor_web, true);
        $criteria->compare('branch_or_sponsor_currency_id', $this->branch_or_sponsor_currency_id);
        $criteria->compare('organization_chart_name', $this->organization_chart_name);
        $criteria->compare('isActive', $this->isActive, true);


        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.branch_or_sponsor_name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCompanyBranch the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getCompanyBranches() {
        $condition = 'isActive =  "Y" ';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' AND id IN (' . Yii::app()->user->user_branch . ')';
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'branch_or_sponsor_name'));
        return CHtml::listData($model, 'id', 'branch_or_sponsor_name');
    }

    public static function getSalaryBranches() {
        if (Yii::app()->user->authorised_user == 1) {
            $condition = 'isActive =  "Y" ';
            if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
                $condition .= ' AND id IN (' . Yii::app()->user->user_branch . ')';
            }
            $model = self::model()->findAll(array('condition' => $condition, 'order' => 'branch_or_sponsor_name'));
            return CHtml::listData($model, 'id', 'branch_or_sponsor_name');
        } else {
            $model_user = User::model()->findByPK(Yii::app()->user->id);
            $model_usergroup = MasUserGroup::model()->find(array('condition' => 'id="' . $model_user->user_group_id . '"'));
            $branch_id = array();
            if ($model_usergroup->salary_tab_permission != '') {
                $branch_id = explode(',', $model_usergroup->salary_tab_permission);
            }
            if(isset(Yii::app()->user->user_branch) && Yii::app()->user->user_branch!=''){
                $permitted_branch_id = explode(',', Yii::app()->user->user_branch);
                $branch_id = array_intersect($branch_id, $permitted_branch_id);
            }
            $branch_details = array();
            $m = 0;
            if (!empty($branch_id)) {
                foreach ($branch_id as $value) {
                    $model_branch = self::model()->findByPK($value);
                    $branch_details[$m]['id'] = $value;
                    $branch_details[$m]['branch_or_sponsor_name'] = $model_branch->branch_or_sponsor_name;
                    $m++;
                }
            }
            if (empty($branch_details)) {
                $branch_details[0]['id'] = '-';
                $branch_details[0]['branch_or_sponsor_name'] = 'No Salary Permission';
            }
            return CHtml::listData($branch_details, 'id', 'branch_or_sponsor_name');
        }
    }

    public static function getBrancheswithtkt() {
        $condition = 'isActive =  "Y" and ticket_provided="Y"';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' AND id IN (' . Yii::app()->user->user_branch . ')';
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'branch_or_sponsor_name'));
        return CHtml::listData($model, 'id', 'branch_or_sponsor_name');
    }

    public static function getBranchewithleavesettlement() {
        $condition = 'isActive =  "Y" and leave_settlement_provided="Y"';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' AND id IN (' . Yii::app()->user->user_branch . ')';
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'branch_or_sponsor_name'));
        return CHtml::listData($model, 'id', 'branch_or_sponsor_name');
    }

    public static function getCompanyBranchesForUser() {
        $condition = 'isActive =  "Y" ';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'branch_or_sponsor_name'));
        return CHtml::listData($model, 'id', 'branch_or_sponsor_name');
    }

    public static function getbranchforapproval() {
        $condition = 'isActive="Y"';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and id IN (' . Yii::app()->user->user_branch . ')';
        }
        $SQL = "SELECT * FROM  `erp_hr_mas_company_branch_sponsor`  WHERE $condition  && id NOT IN (SELECT  e.branch_or_sponsor_id FROM  erp_hr_employee_approve_level h join erp_hr_employee as e on e.id=h.employee_id)";
        $model = Yii::app()->db->createCommand($SQL)->queryAll();
        return CHtml::listData($model, 'id', 'branch_or_sponsor_name');
    }
    public static function getCompanyBranch() {
        $condition = 'isActive =  "Y" ';               
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!=''){
            $condition .= ' AND id IN ('.Yii::app()->user->user_branch.')';
        } 
        $arr_list=array();
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'branch_or_sponsor_name'));
        foreach ($model as $key => $value) {
            $arr_list[$key]['id']=Yii::app()->controller->ciphertext($value->id,"e");
            $arr_list[$key]['branch_or_sponsor_name']=$value->branch_or_sponsor_name;
        }
        return CHtml::listData($arr_list, 'id', 'branch_or_sponsor_name');
        
    }
    public static function getCompanyBranchesChange() {
        $condition = 'isActive =  "Y" AND branch_transfer="Y"';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' AND id IN (' . Yii::app()->user->user_branch . ')';
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'branch_or_sponsor_name'));
        return CHtml::listData($model, 'id', 'branch_or_sponsor_name');
    }
}
