<?php

/**
 * This is the model class for table "{{mas_department}}".
 *
 * The followings are the available columns in table '{{mas_department}}':
 * @property integer $id
 * @property string $certificate_name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class MasCertificate extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_mas_certificate_name}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('certificate_name,reference_no', 'required'),
            array('certificate_name', 'length', 'max' => 255),
            array('certificate_name', 'unique'),
            array('isActive,apply_from', 'length', 'max' => 1),
            array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, certificate_name, reference_no,isActive,created_by,created_datetime,updated_by,updated_datetime', 'safe', 'on' => 'search'),
        );
    }
    function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 26;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' certificate '.$this->certificate_name;
        $model_audit_log->save();
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
       
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'certificate_name' => 'Certificate Name',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBank the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }



    public static function getCertificateName() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'certificate_name');
    }
    
 
}
