<?php

/**
 * This is the model class for table "{{hr_mail_settings}}".
 *
 * The followings are the available columns in table '{{hr_mail_settings}}':
 * @property integer $id
 * @property integer $mail_function
 * @property string $from_mail_id
 * @property string $self_mail
 * @property string $reporting_manager
 * @property string $notifying_employee
 * @property string $custom_mail_id
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class MailSettings extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mail_settings}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('mail_function', 'required'),
			array('mail_function, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('from_mail_id, notifying_employee, custom_mail_id', 'length', 'max'=>750),
                        array('from_mail_name', 'length', 'max'=>700),
			array('self_mail, approval_authority,reporting_manager,attendance_manager, isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, mail_function, from_mail_id, self_mail, reporting_manager, notifying_employee, custom_mail_id, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'maildetails' => array(self::BELONGS_TO, 'MasterMailDetail', 'mail_function'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'mail_function' => 'Mail Function',
			'from_mail_id' => 'From Mail',
			'self_mail' => 'Self Mail',
			'reporting_manager' => 'Reporting Manager',
			'notifying_employee' => 'Notifying Employee',
			'custom_mail_id' => 'Custom Mail',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('mail_function',$this->mail_function);
		$criteria->compare('from_mail_id',$this->from_mail_id,true);
		$criteria->compare('self_mail',$this->self_mail,true);
		$criteria->compare('reporting_manager',$this->reporting_manager,true);
		$criteria->compare('notifying_employee',$this->notifying_employee,true);
		$criteria->compare('custom_mail_id',$this->custom_mail_id,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MailSettings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
