<?php

/**
 * This is the model class for table "{{hr_training_details}}".
 *
 * The followings are the available columns in table '{{hr_training_details}}':
 * @property integer $id
 * @property integer $training_id
 * @property integer $employee_id
 * @property string $training_status
 * @property string $created_date_time
 * @property integer $created_by
 * @property string $updated_date_time
 * @property integer $updated_by
 */
class HrTrainingDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_training_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, training_status', 'required'),
			array('training_id, employee_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('training_status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, training_id, employee_id, training_status, created_date_time, created_by, updated_date_time, updated_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'trainingdetail' => array(self::BELONGS_TO, 'HrTraining', 'training_id'),
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'training_id' => 'Training',
			'employee_id' => 'Employee',
			'training_status' => 'A-Attended,N-Not Attended',
			'created_date_time' => 'Created Date Time',
			'created_by' => 'Created By',
			'updated_date_time' => 'Updated Date Time',
			'updated_by' => 'Updated By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('training_id',$this->training_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('training_status',$this->training_status,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrTrainingDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function gettrainingEmployee($id = null) {
            $condition='1=1';
            if ($id != null){
                $condition .= ' AND training_id =  '.$id;
            }
            $model_user = User::model()->findByPk(Yii::app()->user->id);
            if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
              $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
            }
            $model = self::model()->with('employeedetail')->findAll(array('condition' => $condition, 'group' => 'employee_id', 'order' => 'employeedetail.de_first_name asc'));
            foreach($model as $each){
                $arr_emp[]=$each->employeedetail->employeefullname;
            }
            return implode(',',$arr_emp);
        }
}
