<?php

/**
 * This is the model class for table "{{hr_recruitment_documents}}".
 *
 * The followings are the available columns in table '{{hr_recruitment_documents}}':
 * @property integer $id
 * @property integer $recruit_id
 * @property string $document_id
 * @property string $document_file
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class HrRecruitmentDocuments extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_recruitment_documents}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('document_id', 'required'),
			array('recruit_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('document_no, document_file', 'length', 'max'=>700),
			array('isActive', 'length', 'max'=>1),
                        array('document_file', 'validateDocumentfile'),
                    
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, recruit_id, document_id,document_no, document_file, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'document' => array(self::BELONGS_TO, 'MasDocument', 'document_id'),
		);
	}
        public function validateDocumentfile() {
        $model_upload_recruitment_doc = HrMasterUpload::model()->findByPK(15);
        if ($model_upload_recruitment_doc->isActive == 'Y') {
            if ($this->document_file=='') {
                $this->addError('document_file', 'Document File Cannot be Blank');
                $this->rules(); 
                return false;
            }
        }
        return true;
    }
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'recruit_id' => 'Recruit',
			'document_id' => 'Document Name',
			'document_file' => 'Document File',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('recruit_id',$this->recruit_id);
                $criteria->compare('document_id',$this->document_id);
		$criteria->compare('document_no',$this->document_no,true);
		$criteria->compare('document_file',$this->document_file,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrRecruitmentDocuments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
