<?php

/**
 * This is the model class for table "{{hr_recruitment_analysis}}".
 *
 * The followings are the available columns in table '{{hr_recruitment_analysis}}':
 * @property integer $id
 * @property integer $recruit_id
 * @property integer $question_id
 * @property string $question
 * @property string $answer
 * @property string $max_score
 * @property string $score_secured
 * @property integer $created_by
 * @property string $created_date_time
 */
class HrRecruitmentAnalysis extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_recruitment_analysis}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('question_id, question', 'required'),
			array('recruit_id, question_id, created_by', 'numerical', 'integerOnly'=>true),
			array('max_score, score_secured', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, recruit_id, question_id, question, answer, max_score, score_secured, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'questiondetail' => array(self::BELONGS_TO, 'HrQuestions', 'question_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'recruit_id' => 'Recruit',
			'question_id' => 'Question',
			'question' => 'Question',
			'answer' => 'Answer',
			'max_score' => 'Max Score',
			'score_secured' => 'Score Secured',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('recruit_id',$this->recruit_id);
		$criteria->compare('question_id',$this->question_id);
		$criteria->compare('question',$this->question,true);
		$criteria->compare('answer',$this->answer,true);
		$criteria->compare('max_score',$this->max_score,true);
		$criteria->compare('score_secured',$this->score_secured,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrRecruitmentAnalysis the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
