<?php

/**
 * This is the model class for table "{{hr_recruitment}}".
 *
 * The followings are the available columns in table '{{hr_recruitment}}':
 * @property integer $id
 * @property string $first_name
 * @property string $middle_name
 * @property string $last_name
 * @property string $gender
 * @property string $date_of_birth
 * @property string $email_id
 * @property string $mobile_no
 * @property string $post_applied
 * @property integer $expected_salary
 * @property string $employee_description
 * @property integer $years_experience
 * @property integer $interview_call
 * @property string $interview_date
 * @property integer $employee_rating
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class HrRecruitment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_recruitment}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('first_name, last_name, gender, date_of_birth, email_id, mobile_no, post_applied, expected_salary, years_experience', 'required'),
			array('expected_salary, years_experience, interview_call, employee_rating, created_by, updated_by,branch_id,reference_no', 'numerical', 'integerOnly'=>true),
			array('first_name, middle_name, last_name, email_id, post_applied,incentive_card', 'length', 'max'=>700),
                        array('first_name, last_name, gender, date_of_birth, email_id, mobile_no, post_applied, expected_salary, years_experience', 'required', 'on' => 'excelupload'),
                        array('date_of_birth', 'validaterecruitdate', 'on' => 'excelupload'),
			array('gender', 'length', 'max'=>1),
			array('mobile_no', 'length', 'max'=>200),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, first_name, middle_name, last_name, gender, date_of_birth, email_id, mobile_no, post_applied, expected_salary, employee_description, years_experience, interview_call, interview_date, employee_rating, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'branch' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch_id'),
		);
	}
        public function validaterecruitdate($attribute) {
            $date = $this->date_of_birth;
            if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $date)) {
                return true;
            } else {
                $this->addError($attribute, 'Not in YYYY-mm-dd Format');
                return false;
            }
        }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'first_name' => 'First Name',
			'middle_name' => 'Middle Name',
			'last_name' => 'Last Name',
			'gender' => 'Gender',
			'date_of_birth' => 'Date Of Birth',
			'email_id' => 'Email',
			'mobile_no' => 'Mobile No',
			'post_applied' => 'Post Applied',
			'expected_salary' => 'Expected Salary',
			'employee_description' => 'Employee Description',
			'years_experience' => 'Years Experience',
			'interview_call' => '0=>Not Selected, 1=>selected',
			'interview_date' => 'Interview Date',
			'employee_rating' => 'Employee Rating',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('middle_name',$this->middle_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('date_of_birth',$this->date_of_birth,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('mobile_no',$this->mobile_no,true);
		$criteria->compare('post_applied',$this->post_applied,true);
		$criteria->compare('expected_salary',$this->expected_salary);
		$criteria->compare('employee_description',$this->employee_description,true);
		$criteria->compare('years_experience',$this->years_experience);
		$criteria->compare('interview_call',$this->interview_call);
		$criteria->compare('interview_date',$this->interview_date,true);
		$criteria->compare('employee_rating',$this->employee_rating);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrRecruitment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function getfullname() {
            return ($this->first_name. ' ' .$this->middle_name. ' ' .$this->last_name);
        }
}
