<?php

/**
 * This is the model class for table "{{hr_outsource_overtime}}".
 *
 * The followings are the available columns in table '{{hr_outsource_overtime}}':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $total_working_day
 * @property string $normal_working_day
 * @property string $normal_overtime
 * @property string $night_shift
 * @property string $night_overtime
 * @property string $week_off
 * @property string $absent_with_deduction
 * @property string $absent_without_deduction
 * @property integer $holiday_count
 * @property string $holiday_overtime
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class HrOutsourceOvertime extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_outsource_overtime}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public $employee_code;
    public $employee_name;
    public $shift_name;

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('overtime_month,overtime_year,employee_id', 'required'),
            array('overtime_month,overtime_year,employee_id, total_working_day, holiday_count, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('normal_working_day, normal_overtime, night_shift, night_overtime, week_off, absent_with_deduction, absent_without_deduction, holiday_overtime', 'length', 'max' => 10),
            array('employee_id', 'validatedetail', 'on' => 'excelupload'),
            array('employee_id', 'validateovertime', 'on' => 'excelupload'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, employee_id, total_working_day, normal_working_day, normal_overtime, night_shift, night_overtime, week_off, absent_with_deduction, absent_without_deduction, holiday_count, holiday_overtime, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    public function validatedetail() {
        if ($this->overtime_month != '' && $this->overtime_year != '' && $this->employee_id != '') {
            $condition = 'overtime_month="' . $this->overtime_month . '" and overtime_year="' . $this->overtime_year . '" and employee_id="' . $this->employee_id . '" ';
            $model = self::model()->find(array('condition' => $condition));
            if (!empty($model) && $model->id > 0) {
                $this->addError('employee_id', 'Details already exist for the employee for this month and year');
                return false;
            } else {
                return true;
            }
        }
    }
    
    public function validateovertime() {
        if ($this->overtime_month != '' && $this->overtime_year != '' && $this->employee_id != '') {
            $condition = 'overtime_month="' . $this->overtime_month . '" and overtime_year="' . $this->overtime_year . '" and employee_id="' . $this->employee_id . '" ';
            $model = self::model()->find(array('condition' => $condition));
            if (empty($model)) {
                if (($this->normal_overtime== '' || $this->normal_overtime==0) && ($this->night_overtime== '' || $this->night_overtime==0) && ($this->holiday_overtime== '' || $this->holiday_overtime==0)) {
                    $this->addError('employee_id', 'Please enter overtime Details');
                    return false;
                } else {
                    return true;
                }
            }else{
                return true;
            }
        }
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'employee_id' => 'Employee',
            'total_working_day' => 'Total Working Day',
            'normal_working_day' => 'Normal Working Day',
            'normal_overtime' => 'Normal Overtime',
            'night_shift' => 'Night Shift',
            'night_overtime' => 'Night Overtime',
            'week_off' => 'Week Off',
            'absent_with_deduction' => 'Absent With Deduction',
            'absent_without_deduction' => 'Absent Without Deduction',
            'holiday_count' => 'Holiday Count',
            'holiday_overtime' => 'Holiday Overtime',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('employee_id', $this->employee_id);
        $criteria->compare('total_working_day', $this->total_working_day);
        $criteria->compare('normal_working_day', $this->normal_working_day, true);
        $criteria->compare('normal_overtime', $this->normal_overtime, true);
        $criteria->compare('night_shift', $this->night_shift, true);
        $criteria->compare('night_overtime', $this->night_overtime, true);
        $criteria->compare('week_off', $this->week_off, true);
        $criteria->compare('absent_with_deduction', $this->absent_with_deduction, true);
        $criteria->compare('absent_without_deduction', $this->absent_without_deduction, true);
        $criteria->compare('holiday_count', $this->holiday_count);
        $criteria->compare('holiday_overtime', $this->holiday_overtime, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return HrOutsourceOvertime the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
