<?php

/**
 * This is the model class for table "{{hr_master_function}}".
 *
 * The followings are the available columns in table '{{hr_master_function}}':
 * @property integer $id
 * @property string $functionality
 * @property string $isActive
 */
class HrMasterFunction extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_master_function}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('functionality', 'required'),
			array('functionality', 'length', 'max'=>700),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, functionality, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'functionality' => 'Functionality',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('functionality',$this->functionality,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrMasterFunction the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getfunctionalityname() {
            $condition = 'isActive =  "Y"';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'functionality asc'));
            return CHtml::listData($model, 'id', 'functionality');
        }
        public static function getdetails() {
            $condition = 'isActive =  "Y"';
            $model = self::model()->findAll(array('condition' => $condition));
            $arr=array();
            foreach ($model as $key => $value) {
                $arr[$value->id]=$value->functionality;
            }
            return $arr;
        }
        public static function getfunctionality($branch_id=0) {
            $condition = 'isActive =  "Y"';
            $SQL ="SELECT * FROM  `erp_hr_master_function`  WHERE $condition  && id NOT IN (SELECT  functionality_id FROM  erp_hr_employee_approve_level `F` JOIN `erp_hr_employee` `X` ON (`F`.`employee_id` = `X`.`id`) WHERE branch_or_sponsor_id='$branch_id')";      
            $model = Yii::app()->db->createCommand($SQL)->queryAll(); 
            return CHtml::listData($model, 'id', 'functionality');
        }
}
