<?php

/**
 * This is the model class for table "{{hr_mas_eos_noticeperiod}}".
 *
 * The followings are the available columns in table '{{hr_mas_eos_noticeperiod}}':
 * @property integer $id
 * @property string $period_name
 * @property string $isActive
 * @property integer $month_day_value
 * @property string $type
 */
class HrMasEosNoticeperiod extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mas_eos_noticeperiod}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('period_name, month_day_value, type', 'required'),
			array('month_day_value', 'numerical', 'integerOnly'=>true),
			array('period_name', 'length', 'max'=>255),
			array('isActive, type', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, period_name, isActive, month_day_value, type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'period_name' => 'Period Name',
			'isActive' => 'Is Active',
			'month_day_value' => 'Month Day Value',
			'type' => 'Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('period_name',$this->period_name,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('month_day_value',$this->month_day_value);
		$criteria->compare('type',$this->type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrMasEosNoticeperiod the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
    public static function getEosNoticePeriod() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'sort_order asc'));
        return CHtml::listData($model, 'id', 'period_name');
    }
}
