<?php

/**
 * This is the model class for table "{{hr_mas_certificate_autorization}}".
 *
 * The followings are the available columns in table '{{hr_mas_certificate_autorization}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $designation
 * @property string $upload_url
 * @property string $isActive
 * @property string $created_date_time
 * @property integer $created_by
 */
class HrMasCertificateAutorization extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mas_certificate_authorization}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, designation', 'required'),
			array('created_by', 'numerical', 'integerOnly'=>true),
			array('designation', 'length', 'max'=>255),
			array('authority_signature', 'length', 'max'=>500),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, designation, authority_signature, isActive, created_date_time, created_by', 'safe', 'on'=>'search'),
			array('employee_id', 'validateemployeecode'),
		);
	}
	

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			 'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'designation' => 'Designation',
			'authority_signature' => 'Authority Signature',
			'isActive' => 'Is Active',
			'created_date_time' => 'Created Date Time',
			'created_by' => 'Created By',
		);
	}

	public function validateemployeecode() {
       if ($this->employee_id!= '') {
            $condition='(employee_id="'.$this->employee_id.'")';
            if($this->id!=''){
                $condition.=' AND id!="'.$this->id.'"';
            }
            $model = self::model()->find(array('condition'=>$condition));
            if(!empty($model) && $model->id>0){
                $this->addError('employee_id', 'Employee already exist');
                return false;
            }else{
                return true;
            }
        }
        
    }


	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id,true);
		$criteria->compare('designation',$this->designation,true);
		$criteria->compare('authority_signature',$this->authority_signature,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('created_by',$this->created_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrMasCertificateAutorization the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	  public static function getAuthority() {

        //$condition = 't.isActive =  "Y" AND t.company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 't.isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'employeedetail.employeefullname');
    }
}
