<?php

/**
 * This is the model class for table "{{hr_mas_appraisal_type}}".
 *
 * The followings are the available columns in table '{{hr_mas_appraisal_type}}':
 * @property integer $id
 * @property string $appraisal_type
 * @property string $default_weightage
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class HrMasAppraisalType extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mas_appraisal_type}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('appraisal_type,appraisal_department', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('appraisal_type', 'length', 'max'=>500),
			array('default_weightage', 'length', 'max'=>15),
                        array('default_weightage', 'validateweightage'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, appraisal_type, default_weightage, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}
        function afterSave() {
        $action_type='';
        switch ($this->scenario) {
            case 'add':
                $action_type = 'Created';
                break;
            case 'update':
                $action_type = 'Updated';
                break;
            default:
                $action_type = 'Block/Unblock';
                break;
        }
        $model_audit_log = new HrAuditLog();
        $model_audit_log->functionality = 4;
        $model_audit_log->master_table_id = $this->id;
        $model_audit_log->performed_by = Yii::app()->user->id;
        $model_audit_log->performed_date_time = date('Y-m-d H:i:s');
        $model_audit_log->remarks =$action_type.' appraisal type '.$this->appraisal_type;
        $model_audit_log->save();
    }


	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'departmentdetails' => array(self::BELONGS_TO, 'HrAppraisalDepartment', 'appraisal_department'),
                    
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'appraisal_type' => 'Goal',
			'default_weightage' => 'Default Weightage',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('appraisal_type',$this->appraisal_type,true);
		$criteria->compare('default_weightage',$this->default_weightage,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrMasAppraisalType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getMasAppraisalType() {
            $condition = '1=1 ';               
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'appraisal_type'));
            return CHtml::listData($model, 'id', 'appraisal_type');

        }
        public static function getMasAppraisalTypeBYdepartment($id) {
            $condition = '1=1 ';    
            if($id>0){
               $condition.= ' AND appraisal_department="' . $id . '" AND default_weightage>0';
}
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'appraisal_type'));
            return CHtml::listData($model, 'id', 'appraisal_type');

        }
        public function validateweightage() {
            if ($this->default_weightage<=0) {
                $this->addError('default_weightage', 'Weightage must be greater than zero');
                $this->rules();
            }
            return true;
        }
}
