<?php
class HrGenerelSettings extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_settings}}';
    }
    public $old_package_id;

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('payroll_month,payroll_startdate,payroll_enddate,hours,annual_leave_sal_type', 'required'),
            //array('annual_leave_sal_type,overtime_hours', 'required'),
            array('package_id,ifsc_code,max_admin_users_allowed', 'numerical', 'integerOnly'=>true),
            array('from_mail_id,from_mail_name', 'length', 'max' => 700),
            array('app_version,review_app_version', 'length', 'max' => 700),
            array('watermark_logo_upload,footer_logo_upload,branch_logo_upload,calculate_overtime,general_calendar,hrcalendar,leave_apply_before_current_date,leave_apply_permission,employee_document_upload,include_holiday,lock_attendance_leave,enable_mail,enable_sms,use_hr_code_increment_employee_code,auto_increment_employee_code,consider_advance_leave,consider_threshold_salary,start_time_normal_ot,start_time_weekend_ot,start_time_night_ot,start_time_holiday_ot', 'length', 'max'=>1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,payroll_startdate,payroll_enddate,employee_document_upload, isActive,payroll_month,annual_leave_sal_type,ifsc_code', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
           'packagedetail' => array(self::BELONGS_TO, 'HrSoftwarePackage', 'package_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'payroll_startdate' => 'Start Date',
            'payroll_enddate' => 'End Date',
            'annual_leave_sal_type'=>'Annual Leave Type',
            'payroll_month'=>'Month', 
            'overtime_hours'=>'Overtime', 
            'ifsc_code'=>'Ifsc Code',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return  the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }


 public static function getPayrollProcessing() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'payroll_month', 'payroll_month');
    }
    
    public static function listMonths() {
     $arr_months = array('1'=>'January','02'=>'February','03'=>'March','04'=>'April','05'=>'May','06'=>'June','07'=>'July','08'=>'August','09'=>'September','10'=>'October','11'=>'November','12'=>'December');
                   return $arr_months;
    }
    public static function listMonths1() {
     $arr_months = array('1'=>'January','2'=>'February','3'=>'March','4'=>'April','5'=>'May','6'=>'June','7'=>'July','8'=>'August','9'=>'September','10'=>'October','11'=>'November','12'=>'December');
                   return $arr_months;
    }
    public static function listMonth() {
     $arr_months = array('January'=>'January','February'=>'February','March'=>'March','April'=>'April','May'=>'May','June'=>'June','July'=>'July','August'=>'August','September'=>'September','October'=>'October','November'=>'November','December'=>'December');
                   return $arr_months;
    }
    public static function getMonthName($month) {        
        if(!empty($month)){
            $arr_months = array('01'=>'January','02'=>'February','03'=>'March','04'=>'April','05'=>'May','06'=>'June','07'=>'July','08'=>'August','09'=>'September','10'=>'October','11'=>'November','12'=>'December');
             if (array_key_exists($month, $arr_months)) {
                return $arr_months[$month];
            } 
            //return $arr_months[$month];
        }else{
            return 0;
        }
    }
    public static function getMonthName1($month) {        
        $arr_months = array('1'=>'January','2'=>'February','3'=>'March','4'=>'April','5'=>'May','6'=>'June','7'=>'July','8'=>'August','9'=>'September','10'=>'October','11'=>'November','12'=>'December');
        return $arr_months[$month];
    }
    public static function listYears($less,$high) {
        $arr_years = array();
        $cur_year  = date("Y");
        $start_year = $cur_year-$less;
        $end_year = $cur_year+$high;
        for ($i=$start_year;$i<=$end_year;$i++){
          $arr_years[$i]=$i;
        }
        return $arr_years;
    }
    public static function getMonthbyName($month) {        
        $arr_months = array('1'=>'Jan','02'=>'Feb','03'=>'Mar','04'=>'Apr','05'=>'May','06'=>'June','07'=>'July','08'=>'Aug','09'=>'Sep','10'=>'Oct','11'=>'Nov','12'=>'Dec');
        return $arr_months[$month];
    }
   public static function getMonthAbb($month) {        
        $arr_months = array('1'=>'Jan','2'=>'Feb','3'=>'Mar','4'=>'Apr','5'=>'May','6'=>'June','7'=>'July','8'=>'Aug','9'=>'Sept','10'=>'Oct','11'=>'Nov','12'=>'Dec');
        return $arr_months[$month];
    }
    public static function listSelectedMonth() {
        $arr_months = array(
            '1' => 'January',
            '2' => 'February',
            '3' => 'March',
            '4' => 'April',
            '5' => 'May',
            '6' => 'June',
            '7' => 'July',
            '8' => 'August',
            '9' => 'September',
            '10' => 'October',
            '11' => 'November',
            '12' => 'December'
        );
        $selected_months = array();
        $cur_month = date("n");
        if($cur_month==12){
            $cur_month=1;
        }
        $start_month = $cur_month - 1;
        for ($i = $start_month; $i <= 12; $i++) {
            $month = ($i < 1) ? 12 + $i : $i;
            $selected_months[$month] = $arr_months[$month];
        }
        return $arr_months;
    }

}
