<?php

/**
 * This is the model class for table "{{hr_employee_document_expiry}}".
 *
 * The followings are the available columns in table '{{hr_employee_document_expiry}}':
 * @property integer $id
 * @property integer $employee_id
 * @property string $description
 * @property string $document_number
 * @property integer $document_type
 * @property string $document_name
 * @property string $validate_till_date
 * @property string $renew_on
 * @property integer $status
 * @property string $inprocess_date
 */
class HrEmployeeDocumentExpiry extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_document_expiry}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, description, document_number, document_type, document_name, validate_till_date, renew_on, status, inprocess_date', 'required'),
			array('employee_id, document_type, status', 'numerical', 'integerOnly'=>true),
			array('description, document_number', 'length', 'max'=>30),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, description, document_number, document_type, document_name, validate_till_date, renew_on, status, inprocess_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'description' => 'Description',
			'document_number' => 'Document Number',
			'document_type' => 'Document Type',
			'document_name' => 'Document Name',
			'validate_till_date' => 'Validate Till Date',
			'renew_on' => 'Renew On',
			'status' => 'Status',
			'inprocess_date' => 'Inprocess Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('document_number',$this->document_number,true);
		$criteria->compare('document_type',$this->document_type);
		$criteria->compare('document_name',$this->document_name,true);
		$criteria->compare('validate_till_date',$this->validate_till_date,true);
		$criteria->compare('renew_on',$this->renew_on,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('inprocess_date',$this->inprocess_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeDocumentExpiry the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
