<?php

/**
 * This is the model class for table "{{hr_employee_attendance_excuse_details}}".
 *
 * The followings are the available columns in table '{{hr_employee_attendance_excuse_details}}':
 * @property integer $id
 * @property integer $excuse_id
 * @property integer $type
 * @property string $customer_name
 * @property string $excuse_date
 * @property string $start_time
 * @property string $end_time
 * @property string $excuse_reason
 * @property string $document
 * @property string $excuse_status
 * @property integer $attendance_status
 * @property integer $rejected_level
 */
class HrEmployeeAttendanceExcuseDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_attendance_excuse_details}}';
	}
        public $emp_id,$excuse_start_date_time,$excuse_end_date_time;
        /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type,excuse_date,excuse_reason,start_time,end_time', 'required'),
			array('excuse_id, type, attendance_status, rejected_level', 'numerical', 'integerOnly'=>true),
			array('customer_name, document', 'length', 'max'=>700),
			array('excuse_status', 'length', 'max'=>1),
                        array('customer_name', 'validatecustomer'),
                        array('employee_id', 'validateexcusedate'),
                        array('start_time', 'validateexcusetime'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, excuse_id, type, customer_name, excuse_date, start_time, end_time, excuse_reason, document, excuse_status, attendance_status, rejected_level', 'safe', 'on'=>'search'),
		);
	}
        public function validatecustomer() {
            if ($this->type==1) {
                if ($this->customer_name=='') {
                    $this->addError('customer_name', 'Please Enter Business Partner for Business Meeting');
                    $this->rules();
                }
            }else if ($this->type==3) {
                if ($this->visit_area=='') {
                    $this->addError('visit_area', 'Visit Area cannot be blank for Market Visit');
                    $this->rules();
                }
            }
            return true;
        }
        public function validateexcusedate($attribute) {
            if($this->emp_id!=''){
                if ($this->excuse_date!='0000-00-00' && $this->excuse_date!='') {
                    $condition='excusedetail.employee_id="' .$this->emp_id. '" AND excuse_date="' . $this->excuse_date . '" AND ((start_time<="' . $this->start_time . '" AND end_time>="' . $this->end_time . '") OR  (start_time BETWEEN  "' . $this->start_time . '" AND  "' . $this->end_time . '"
                                    OR end_time BETWEEN  "' . $this->start_time . '" AND  "' . $this->end_time . '"))';
                    if($this->id>0){
                        $condition.=' AND t.id!="'.$this->id.'"';
                    }
                    if($this->excuse_id>0){
                        $condition.=' AND t.excuse_id!="'.$this->excuse_id.'"';
                    }
                    $model = self::model()->with('excusedetail')->find(array('condition' =>$condition));
                    if(!empty($model)){
                        $this->addError($attribute, 'Excuse already exist in '.date("d/m/Y",strtotime($model->excuse_date)).' from '.date("H:i",strtotime($model->start_time)).' to '.date("H:i",strtotime($model->end_time)));
                        return false;
                    }else{
                        return true;
                    }
                }
            }
        }
        public function validateexcusetime($attribute) {
            if($this->emp_id!=''){
                if ($this->start_time!='' && $this->start_time!='00:00' && $this->end_time!='' && $this->end_time!='00:00') {
                    $start_date_time=$this->excuse_date.' '.$this->start_time;
                    $end_date_time=$this->excuse_date.' '.$this->end_time;
                    if(strtotime($end_date_time)<strtotime($start_date_time)){
                        $this->addError($attribute, 'End time must be greater than Start Time.Time must be in 24 hrs format');
                        return false;
                    }else{
                        return true;
                    }
                }
            }
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'excusedetail' => array(self::BELONGS_TO, 'HrEmployeeAttendanceExcuse', 'excuse_id'),
                    'typedetail' => array(self::BELONGS_TO, 'HrMasExcuse', 'type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'excuse_id' => 'Excuse',
			'type' => '1-Meeting,2-Excuse',
			'customer_name' => 'Business Partner',
			'excuse_date' => 'Date',
			'start_time' => 'Start Time',
			'end_time' => 'End Time',
			'excuse_reason' => 'Reason / Purpose',
			'document' => 'Document',
			'excuse_status' => 'Excuse Status',
			'attendance_status' => 'Attendance Status',
			'rejected_level' => 'Rejected Level',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('excuse_id',$this->excuse_id);
		$criteria->compare('type',$this->type);
		$criteria->compare('customer_name',$this->customer_name,true);
		$criteria->compare('excuse_date',$this->excuse_date,true);
		$criteria->compare('start_time',$this->start_time,true);
		$criteria->compare('end_time',$this->end_time,true);
		$criteria->compare('excuse_reason',$this->excuse_reason,true);
		$criteria->compare('document',$this->document,true);
		$criteria->compare('excuse_status',$this->excuse_status,true);
		$criteria->compare('attendance_status',$this->attendance_status);
		$criteria->compare('rejected_level',$this->rejected_level);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeAttendanceExcuseDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
