<?php

/**
 * This is the model class for table "{{hr_department_approve_level}}".
 *
 * The followings are the available columns in table '{{hr_department_approve_level}}':
 * @property integer $id
 * @property integer $functionality_id
 * @property integer $department_id
 * @property integer $max_level
 * @property string $level_1_type
 * @property integer $level_1_authority
 * @property string $level_2_type
 * @property integer $level_2_authority
 * @property string $level_3_type
 * @property integer $level_3_authority
 * @property string $level_4_type
 * @property integer $level_4_authority
 * @property string $level_5_type
 * @property integer $level_5_authority
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class HrDepartmentApproveLevel extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_department_approve_level}}';
	}
        public $line_manager;
        public $supervisor;
        public $functionality_name;

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('functionality_id, max_level', 'required'),
			array('functionality_id, department_id, max_level, level_1_authority, level_2_authority, level_3_authority, level_4_authority, level_5_authority, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('level_1_type, level_2_type, level_3_type, level_4_type, level_5_type', 'length', 'max'=>1),
                        array('max_level', 'validatelevelapproval'),
                        array('max_level', 'validateDuplicateType'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, functionality_id, department_id, max_level, level_1_type, level_1_authority, level_2_type, level_2_authority, level_3_type, level_3_authority, level_4_type, level_4_authority, level_5_type, level_5_authority, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'departmentdetail' => array(self::BELONGS_TO, 'MasDepartment', 'department_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'functionality_id' => 'Functionality',
			'department_id' => 'Department',
			'max_level' => 'Max Level',
			'level_1_type' => 'Level 1 Type',
			'level_1_authority' => 'Level 1 Authority',
			'level_2_type' => 'Level 2 Type',
			'level_2_authority' => 'Level 2 Authority',
			'level_3_type' => 'Level 3 Type',
			'level_3_authority' => 'Level 3 Authority',
			'level_4_type' => 'Level 4 Type',
			'level_4_authority' => 'Level 4 Authority',
			'level_5_type' => 'Level 5 Type',
			'level_5_authority' => 'Level 5 Authority',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}
        public function validatelevelapproval() {
            if($this->max_level != '') {
                if($this->max_level==1){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->level_1_type=='H' &&($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==2){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->level_1_type=='H' &&($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_type=='') {
                        $this->addError('level_2_type', 'Select Level 2 Type');
                        return false;
                    }else if ($this->level_2_type=='H' &&($this->level_2_authority=='' || $this->level_2_authority==0)) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==3){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->level_1_type=='H' &&($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_type=='') {
                        $this->addError('level_2_type', 'Select Level 2 Type');
                        return false;
                    }else if ($this->level_2_type=='H' &&($this->level_2_authority=='' || $this->level_2_authority==0)) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else if ($this->level_3_type=='') {
                        $this->addError('level_3_type', 'Select Level 3 Type');
                        return false;
                    }else if ($this->level_3_type=='H' &&($this->level_3_authority=='' || $this->level_3_authority==0)) {
                        $this->addError('level_3_authority', 'Select Level 3 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==4){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->level_1_type=='H' &&($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_type=='') {
                        $this->addError('level_2_type', 'Select Level 2 Type');
                        return false;
                    }else if ($this->level_2_type=='H' &&($this->level_2_authority=='' || $this->level_2_authority==0)) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else if ($this->level_3_type=='') {
                        $this->addError('level_3_type', 'Select Level 3 Type');
                        return false;
                    }else if ($this->level_3_type=='H' &&($this->level_3_authority=='' || $this->level_3_authority==0)) {
                        $this->addError('level_3_authority', 'Select Level 3 Authority');
                        return false;
                    }else if ($this->level_4_type=='') {
                        $this->addError('level_4_type', 'Select Level 4 Type');
                        return false;
                    }else if ($this->level_4_type=='H' &&($this->level_4_authority=='' || $this->level_4_authority==0)) {
                        $this->addError('level_4_authority', 'Select Level 4 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==5){
                    if ($this->level_1_type=='') {
                        $this->addError('level_1_type', 'Select Level 1 Type');
                        return false;
                    }else if ($this->level_1_type=='H' &&($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_type=='') {
                        $this->addError('level_2_type', 'Select Level 2 Type');
                        return false;
                    }else if ($this->level_2_type=='H' &&($this->level_2_authority=='' || $this->level_2_authority==0)) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else if ($this->level_3_type=='') {
                        $this->addError('level_3_type', 'Select Level 3 Type');
                        return false;
                    }else if ($this->level_3_type=='H' &&($this->level_3_authority=='' || $this->level_3_authority==0)) {
                        $this->addError('level_3_authority', 'Select Level 3 Authority');
                        return false;
                    }else if ($this->level_4_type=='') {
                        $this->addError('level_4_type', 'Select Level 4 Type');
                        return false;
                    }else if ($this->level_4_type=='H' &&($this->level_4_authority=='' || $this->level_4_authority==0)) {
                        $this->addError('level_4_authority', 'Select Level 4 Authority');
                        return false;
                    }else if ($this->level_5_type=='') {
                        $this->addError('level_5_type', 'Select Level 5 Type');
                        return false;
                    }else if ($this->level_5_type=='H' &&($this->level_5_authority=='' || $this->level_5_authority==0)) {
                        $this->addError('level_5_authority', 'Select Level 5 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }
            }
        }
        public function validateDuplicateType()
        {
            if($this->max_level>0){
                $maxLevel = $this->max_level; // Set the maximum level
                $authorityTypes = [];
                $hasDuplicates = false;
                for ($level = 1; $level <= $maxLevel; $level++) {
                    $value = $this->{'level_' . $level . '_type'};
                    if (!empty($value) && ($value=='S' || $value=='L')) {
                        if (isset($authorityTypes[$value])) {
                            $this->addError('level_' . $level . '_type', 'Duplicate entry found in level ' . $level);
                            $hasDuplicates = true;
                        } else {
                            $authorityTypes[$value] = true;
                        }
                    }
                }
                return !$hasDuplicates;
            }else{
                if($this->max_level==0){
                    $this->addError('max_level', 'Level Must be Greater than 0');
                        return false;
                }else{
                    return true;
                }
            }
        }
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('functionality_id',$this->functionality_id);
		$criteria->compare('department_id',$this->department_id);
		$criteria->compare('max_level',$this->max_level);
		$criteria->compare('level_1_type',$this->level_1_type,true);
		$criteria->compare('level_1_authority',$this->level_1_authority);
		$criteria->compare('level_2_type',$this->level_2_type,true);
		$criteria->compare('level_2_authority',$this->level_2_authority);
		$criteria->compare('level_3_type',$this->level_3_type,true);
		$criteria->compare('level_3_authority',$this->level_3_authority);
		$criteria->compare('level_4_type',$this->level_4_type,true);
		$criteria->compare('level_4_authority',$this->level_4_authority);
		$criteria->compare('level_5_type',$this->level_5_type,true);
		$criteria->compare('level_5_authority',$this->level_5_authority);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrDepartmentApproveLevel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
