<?php

/**
 * This is the model class for table "{{hr_audit_log_functionality}}".
 *
 * The followings are the available columns in table '{{hr_audit_log_functionality}}':
 * @property integer $id
 * @property string $symbolic_name
 * @property string $symbolic_code
 * @property string $isActive
 */
class HrAuditLogFunctionality extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_audit_log_functionality}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('symbolic_name, symbolic_code', 'required'),
			array('symbolic_name', 'length', 'max'=>255),
			array('symbolic_code', 'length', 'max'=>100),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, symbolic_name, symbolic_code, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'symbolic_name' => 'Symbolic Name',
			'symbolic_code' => 'Symbolic Code',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('symbolic_name',$this->symbolic_name,true);
		$criteria->compare('symbolic_code',$this->symbolic_code,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrAuditLogFunctionality the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
