<?php

/**
 * This is the model class for table "{{hr_attendance_upload_format}}".
 *
 * The followings are the available columns in table '{{hr_attendance_upload_format}}':
 * @property integer $id
 * @property string $use_employee_code_r_biometric
 * @property integer $employee_id
 * @property integer $biometric_id
 * @property integer $attendance_date
 * @property integer $login_time
 * @property integer $logout_time
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class HrAttendanceUploadFormat extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_attendance_upload_format}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('use_employee_code_r_biometric,date_format,attendance_date,time_from', 'required'),
            array('employee_id, biometric_id, attendance_date, login_time, logout_time,status_column,status_time, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('use_employee_code_r_biometric,time_from', 'length', 'max' => 1),
            array('status_login,status_logout', 'length', 'max' => 50),
            array('use_employee_code_r_biometric', 'validateids'),
            array('time_from', 'validatetimestatus'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, use_employee_code_r_biometric, employee_id, biometric_id, attendance_date,time_from, login_time, logout_time,status_login,status_logout, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    public function validateids() {
        if ($this->use_employee_code_r_biometric == 'E') {
            if ($this->employee_id == '') {
                $this->addError('employee_id', 'Employee ID column number must be greater than 0');
                return false;
            }else{
                return true;
            }
        } else if ($this->use_employee_code_r_biometric == 'B') {
            if ($this->biometric_id == '') {
                $this->addError('biometric_id', 'Biometric ID column number must be greater than 0');
                return false;
            }else{
                return true;
            }
        }
    }
    public function validatetimestatus() {
        if ($this->time_from == 'C') {
            if ($this->login_time == '') {
                $this->addError('login_time', 'Login Time column number must be greater than 0');
                return false;
            }else if($this->logout_time == '') {
                $this->addError('logout_time', 'Logout Time column number must be greater than 0');
                return false;
            }else{
                return true;
            }
        } else if ($this->time_from == 'S') {
            if ($this->status_login == '') {
                $this->addError('status_column', 'Status column number must be greater than 0');
                return false;
            }else if ($this->status_login == '') {
                $this->addError('status_login', 'Login Status Type cannot be blank');
                return false;
            }else if ($this->status_logout == '') {
                $this->addError('status_logout', 'Logout Status Type cannot be blank');
                return false;
            }else if ($this->status_time == '') {
                $this->addError('status_time', 'Status Time column number must be greater than 0');
                return false;
            }else{
                return true;
            }
        }
    }
    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'branch_details' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'use_employee_code_r_biometric' => 'ID Type',
            'employee_id' => 'Employee',
            'biometric_id' => 'Biometric',
            'date_format' =>'Date Format',
            'attendance_date' => 'Attendance Date',
            'time_from' => 'Time From',
            'login_time' => 'Login Time',
            'logout_time' => 'Logout Time',
            'status_login' => 'Login Status Type',
            'status_logout' => 'Logout Status Type',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('use_employee_code_r_biometric', $this->use_employee_code_r_biometric, true);
        $criteria->compare('employee_id', $this->employee_id);
        $criteria->compare('biometric_id', $this->biometric_id);
        $criteria->compare('attendance_date', $this->attendance_date);
        $criteria->compare('login_time', $this->login_time);
        $criteria->compare('logout_time', $this->logout_time);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return HrAttendanceUploadFormat the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
