<?php

/**
 * This is the model class for table "{{hr_appraisal_analysis}}".
 *
 * The followings are the available columns in table '{{hr_appraisal_analysis}}':
 * @property integer $id
 * @property integer $appraisal_id
 * @property integer $question_id
 * @property string $question
 * @property string $employee_answer
 * @property string $employee_score
 * @property string $lm_answer
 * @property string $lm_score
 * @property string $hr_answer
 * @property string $hr_score
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class HrAppraisalAnalysis extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_appraisal_analysis}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('question', 'required'),
                        array('question_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
                        array('question_id, question,level1_answer,level1_score', 'required','on'=>'level1review'),
                        array('question_id, question,level2_answer,level2_score', 'required','on'=>'level2review'),
                        array('question_id, question,level3_answer,level3_score', 'required','on'=>'level3review'),
                        array('question_id, question,level4_answer,level4_score', 'required','on'=>'level4review'),
                        array('question_id, question,level5_answer,level5_score', 'required','on'=>'level5review'),
			array('appraisal_id, appraisal_type,created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('level1_score, level2_score, level3_score,level4_score,level5_score,question_weightage', 'length', 'max'=>10),
			array('isActive', 'length', 'max'=>1),
                        array('appraisal_goal', 'type', 'type' => 'string'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, appraisal_id, appraisal_type,appraisal_goal,target_achieved_date,question_id, question, employee_answer, employee_score, lm_answer, lm_score, hr_answer, hr_score, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'questiondetail' => array(self::BELONGS_TO, 'HrAppraisalQuestions', 'question_id'),
                    'typedetail' => array(self::BELONGS_TO, 'HrMasAppraisalType', 'appraisal_type'),
                    'appraisaldetail' => array(self::BELONGS_TO, 'HrAppraisal', 'question_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'appraisal_id' => 'Appraisal',
			'question_id' => 'KPI',
			'question' => 'KPI',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('appraisal_id',$this->appraisal_id);
		$criteria->compare('question_id',$this->question_id);
		$criteria->compare('question',$this->question,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrAppraisalAnalysis the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
