<?php

/**
 * This is the model class for table "{{hr_employee_salary_advance_payment}}".
 *
 * The followings are the available columns in table '{{hr_employee_salary_advance_payment}}':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $advance_id
 * @property string $advance_amount
 * @property string $payment_date
 */
class EmployeeSalaryAdvancePayment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_salary_advance_payment}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, advance_id, advance_amount, payment_date', 'required'),
			array('employee_id, advance_id', 'numerical', 'integerOnly'=>true),
			array('advance_amount', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, advance_id, advance_amount, payment_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'advance_id' => 'Advance',
			'advance_amount' => 'Advance Amount',
			'payment_date' => 'Payment Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('advance_id',$this->advance_id);
		$criteria->compare('advance_amount',$this->advance_amount,true);
		$criteria->compare('payment_date',$this->payment_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeSalaryAdvancePayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function generateSubledger() {
        $user_id = 0;
        $subledger_id = 0;
        if ($this->employee_id > 0)
            $user_id = User::model()->find(array('condition' => 'employee_id=' . $this->employee_id))->id;
        if ($user_id > 0)
            $subledger_id = FinanceSubledger::model()->find(array('condition' => 'subledger_type_id=3 AND parent_id=' . $user_id))->id;
        return $subledger_id;
	}

	public function postVoucher()
    {
		Yii::import('application.modules.finance.models.*');
		if( $this->advance_amount > 0 ) :
		
			$model = new FinanceVoucherHead;
			$model->voucher_type = 2;
			$model->voucher_no =  FinanceVoucherType::getVoucherno(2, true);
			$model->voucher_date = $this->payment_date;
			$model->due_date = $model->voucher_date;
			$model->currency = 'AED';
			$model->exchange_rate =  1;
			$model->header_table_id = $this->id;
			$model->reference_no = "Salary advance Repaid";
			$model->is_posted = 'Y';
			$model->total_voucher_amount = $this->advance_amount;
			$model->created_by = Yii::app()->user->id;
			$model->created_datetime = date('Y-m-d h:i:s');
			$model->save(false);

			$this->voucher_id = $model->id;
			$this->posted= "Y";

			//Debited to cash//advance deducted from receivable
			$debitModel = new FinanceVoucherItems;
			$debitModel->header_id = $model->id;
			$debitModel->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('cash_account');
			$debitModel->subledger_id = FinanceSystemAccountsMapping::getSystemdefault_subledger('cash_account');
			$debitModel->narration = "Salary advance Repaid";
			$debitModel->amount = $this->advance_amount;
			$debitModel->save(false);

			//advance deducted from receivable
			$creditModel = new FinanceVoucherItems;
			$creditModel->header_id = $model->id;
			$creditModel->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('employee_advance_salary');
			$creditModel->subledger_id = $this->generateSubledger();
			$creditModel->narration = "Salary advance Repaid";
			$creditModel->amount = -1* $this->advance_amount;
			$creditModel->save(false);
		endif;
    }
}
