<?php

/**
 * This is the model class for table "{{hr_employee_purchase}}".
 *
 * The followings are the available columns in table '{{hr_employee_purchase}}':
 * @property integer $id
 * @property integer $function_type
 * @property integer $employee_id
 * @property integer $payment_mode
 * @property string $grand_total
 * @property integer $status
 * @property integer $line_manager_id
 * @property string $line_manager_approved_date
 * @property string $line_manager_comment
 * @property integer $approve_level2_id
 * @property string $approve_level2_date
 * @property string $approve_level2_comment
 * @property integer $approve_level3_id
 * @property string $approve_level3_date
 * @property string $approve_level3_comment
 * @property integer $approved_by
 * @property string $approved_date
 * @property string $hr_comment
 * @property string $apply_date
 * @property integer $apply_by
 * @property integer $lm_view_status
 * @property integer $view_status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class EmployeePurchase extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_purchase}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, payment_mode, grand_total', 'required'),
			array('function_type,last_approved_level, employee_id, payment_mode, status, approve_level2_id, approve_level3_id, approved_by, apply_by, lm_view_status, view_status, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('grand_total', 'length', 'max'=>15),
                        array('function_type', 'validatefunctiontype'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, function_type, employee_id, payment_mode, grand_total, status,approve_level2_id, approve_level2_date, approve_level2_comment, approve_level3_id, approve_level3_date, approve_level3_comment, approved_by, approved_date, apply_date, apply_by, lm_view_status, view_status, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'pdt_detail' => array(self::HAS_MANY, 'EmployeePurchaseDetail', 'purchase_id'),
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
                    'level1' => array(self::BELONGS_TO, 'Employee', 'approve_level1_id'),
                    'level2' => array(self::BELONGS_TO, 'Employee', 'approve_level2_id'),
                    'level3' => array(self::BELONGS_TO, 'Employee', 'approve_level3_id'),
                    'level4' => array(self::BELONGS_TO, 'Employee', 'approve_level4_id'),
                    'level5' => array(self::BELONGS_TO, 'Employee', 'approve_level5_id'),
                    'finalapprove' => array(self::BELONGS_TO, 'Employee', 'approved_by'),
		);
	}
        public function validatefunctiontype() {
            if ($this->function_type == ''|| $this->function_type ==0) {
                $this->addError('function_type', 'Approval level missing.Contact HR');
                $this->rules();
            }
            return true;
        }
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'function_type' => 'For Product Request Approval Procedure',
			'employee_id' => 'Employee',
			'payment_mode' => 'Payment Mode',//'1-Cash,2-From Salary',
			'grand_total' => 'Grand Total',
			'status' => 'Status',
			'approve_level2_id' => 'Approve Level2',
			'approve_level2_date' => 'Approve Level2 Date',
			'approve_level2_comment' => 'Approve Level2 Comment',
			'approve_level3_id' => 'Approve Level3',
			'approve_level3_date' => 'Approve Level3 Date',
			'approve_level3_comment' => 'Approve Level3 Comment',
			'approved_by' => 'Approved',
			'approved_date' => 'Approved Date',
			'apply_date' => 'Apply Date',
			'apply_by' => 'Apply By',
			'lm_view_status' => 'Lm View Status',
			'view_status' => '0-Not viewed,1-Viewed',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('function_type',$this->function_type);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('payment_mode',$this->payment_mode);
		$criteria->compare('grand_total',$this->grand_total,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('line_manager_id',$this->line_manager_id);
		$criteria->compare('line_manager_approved_date',$this->line_manager_approved_date,true);
		$criteria->compare('line_manager_comment',$this->line_manager_comment,true);
		$criteria->compare('approve_level2_id',$this->approve_level2_id);
		$criteria->compare('approve_level2_date',$this->approve_level2_date,true);
		$criteria->compare('approve_level2_comment',$this->approve_level2_comment,true);
		$criteria->compare('approve_level3_id',$this->approve_level3_id);
		$criteria->compare('approve_level3_date',$this->approve_level3_date,true);
		$criteria->compare('approve_level3_comment',$this->approve_level3_comment,true);
		$criteria->compare('approved_by',$this->approved_by);
		$criteria->compare('approved_date',$this->approved_date,true);
		$criteria->compare('hr_comment',$this->hr_comment,true);
		$criteria->compare('apply_date',$this->apply_date,true);
		$criteria->compare('apply_by',$this->apply_by);
		$criteria->compare('lm_view_status',$this->lm_view_status);
		$criteria->compare('view_status',$this->view_status);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeePurchase the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
    public static function getStatus($id) {
            switch ($id) {
                case 1:
                    $status = "Applied";
                    break;
                case 2:
                    $status = "Level 1 Approved";
                    break;
                case 3:
                    $status = "Level 1 Rejected";
                    break;
                case 4:
                    $status = "Level 2 Approved";
                    break;
                case 5:
                    $status = "Level 2 Rejected";
                    break;
                case 6:
                    $status = "Level 3 Approved";
                    break;
                case 7:
                    $status = "Level 3 Rejected";
                    break;
                case 8:
                    $status = "Level 4 Approved";
                    break;
                case 9:
                    $status = "Level 4 Rejected";
                    break;
                case 10:
                    $status = "Level 5 Approved";
                    break;
                case 11:
                    $status = "Level 5 Rejected";
                    break;
                case 12:
                    $status = "Approved";
                    break;
                case 13:
                    $status = "Rejected";
                    break;
                case 14:
                    $status = "Cancelled";
                    break;
            }
            return $status;
        }
    public static function getPendingapproval($branch, $from) {
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level';
        if ($branch > 0) {
            $condition .= ' AND employeedetail.branch_or_sponsor_id="' . $branch . '"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        $model_details = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_id = array();
        $resignation_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->status != 3 && $value->status != 5 && $value->status != 7 && $value->status != 9 && $value->status != 11) {
                if($value->status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($value->function_type>0 && $next_approval_level <= $value->approvelevel->max_level) {
                        if ($next_approval_level == 1 && $value->approvelevel->level_1_type == 'H' && $value->approvelevel->level_1_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && $value->approvelevel->level_2_type == 'H' && $value->approvelevel->level_2_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && $value->approvelevel->level_3_type == 'H' && $value->approvelevel->level_3_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && $value->approvelevel->level_4_type == 'H' && $value->approvelevel->level_4_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && $value->approvelevel->level_5_type == 'H' && $value->approvelevel->level_5_authority == $hr_connected_employee) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $resignation_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $resignation_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

    public static function getintermediateapproval($employee_id, $from) {
        $model_details = self::model()->with('employeedetail', 'approvelevel')->findAll(array('condition' => 'employeedetail.isActive="Y" AND last_approved_level<t.max_level'));
        $arr_id = array();
        $resignation_id = 0;
        foreach ($model_details as $key => $value) {
            if ($value->status != 3 && $value->status != 5 && $value->status != 7 && $value->status != 9 && $value->status != 11) {
                if($value->status<12){
                    $last_approved_level = $value->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    if ($value->function_type>0 && $next_approval_level <= $value->max_level) {
                        if ($next_approval_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        } else if ($next_approval_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                            $arr_id[] = $value->id;
                        }
                    }
                }
            }
        }
        if (!empty($arr_id)) {
            $resignation_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $resignation_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }
}
