<?php

/**
 * This is the model class for table "{{hr_employee_loan}}".
 *
 * The followings are the available columns in table '{{hr_employee_loan}}':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $loan_id
 * @property string $loan_amount
 * @property string $date_payment
 * @property integer $loan_installment
 * @property string $posted
 */
class EmployeeLoan extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{hr_employee_loan}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('employee_id, loan_id, loan_amount, date_payment, loan_installment', 'required'),
            array('employee_id, loan_id, loan_installment', 'numerical', 'integerOnly' => true),
            array('loan_amount', 'length', 'max' => 10),
            array('posted', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, employee_id, loan_id, loan_amount, date_payment, loan_installment, posted', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
			'parent' => array(self::BELONGS_TO, 'EmployeeLoanDetail', 'loan_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'employee_id' => 'Employee',
            'loan_id' => 'Loan',
            'loan_amount' => 'Loan Amount',
            'date_payment' => 'Date Payment',
            'loan_installment' => 'Loan Installment',
            'posted' => 'Posted',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('employee_id', $this->employee_id);
        $criteria->compare('loan_id', $this->loan_id);
        $criteria->compare('loan_amount', $this->loan_amount, true);
        $criteria->compare('date_payment', $this->date_payment, true);
        $criteria->compare('loan_installment', $this->loan_installment);
        $criteria->compare('posted', $this->posted, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return EmployeeLoan the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

	//Finance
	
	public function generateSubledger() {
        $user_id = 0;
        $subledger_id = 0;
        if ($this->employee_id > 0)
            $user_id = User::model()->find(array('condition' => 'employee_id=' . $this->employee_id))->id;
        if ($user_id > 0)
            $subledger_id = FinanceSubledger::model()->find(array('condition' => 'subledger_type_id=3 AND parent_id=' . $user_id))->id;
        return $subledger_id;
	}
	
    public function postVoucher()
    {
		Yii::import('application.modules.finance.models.*');
		if( $this->loan_amount > 0 ) :
		
			$model = new FinanceVoucherHead;
			$model->voucher_type = 2;
			$model->voucher_no =  FinanceVoucherType::getVoucherno(2, true);
			$model->voucher_date = $this->date_payment;
			$model->due_date = $model->voucher_date;
			$model->currency = 'AED';
			$model->exchange_rate =  1;
			$model->header_table_id = $this->id;
			$model->reference_no = "Loan Repaid";
			$model->is_posted = 'Y';
			$model->total_voucher_amount = $this->loan_amount;
			$model->created_by = Yii::app()->user->id;
			$model->created_datetime = date('Y-m-d h:i:s');
			$model->save(false);

			$this->voucher_id = $model->id;
			$this->posted= "Y";

			//Loan deducted from receivable
			$debitModel = new FinanceVoucherItems;
			$debitModel->header_id = $model->id;
			$debitModel->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('cash_account');
			$debitModel->subledger_id = FinanceSystemAccountsMapping::getSystemdefault_subledger('cash_account');
			$debitModel->narration = "Loan repaid";
			$debitModel->amount = $this->loan_amount;
			$debitModel->save(false);

			//Debited to cash
			$creditModel = new FinanceVoucherItems;
			$creditModel->header_id = $model->id;
			$creditModel->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('employee_loan');
			$creditModel->subledger_id = $this->generateSubledger();
			$creditModel->narration = "Loan repaid";
			$creditModel->amount = -1* $this->loan_amount;
			$creditModel->save(false);
		endif;
    }
}
