<?php

/**
 * This is the model class for table "crm_hr_employee_leave_detail".
 *
 * The followings are the available columns in table 'crm_hr_employee_leave_detail':
 * @property integer $id
 * @property integer $employee_id
 * @property string $leave_start_date
 * @property string $leave_end_date
 * @property string $no_days
 * @property string $leave_reason
 * @property string $medical_certificate
 * @property integer $leave_type
 * @property integer $leave_status
 * @property integer $line_manager_id
 * @property string $line_manager_approved_date
 * @property string $line_manager_comment
 * @property integer $approved_id
 * @property string $approved_date
 * @property string $hr_comment
 * @property string $leave_approval_document
 * @property string $apply_date
 * @property integer $apply_by
 * @property integer $view_status
 */
class EmployeeLeaveDetail extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_employee_leave_detail}}';
    }

    public $employee_name;
    public $half_day;
    public $available_leave;
    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('employee_id, leave_start_date, leave_end_date, no_days, leave_reason,leave_type', 'required'),
            array('employee_id, leave_type,ticket_applied, leave_status, line_manager_id, approved_id, apply_by, view_status,last_approved_level,last_cancel_level', 'numerical', 'integerOnly' => true),
            array('no_days', 'length', 'max' => 5),
            array('half_day_leave', 'length', 'max' => 1),
            array('half_day_time', 'length', 'max' => 2),
            //array('employee_id', 'checkforlinemanager'),
            array('medical_certificate', 'length', 'max' => 500),
            array('leave_approval_document', 'length', 'max' => 255),
            array('function_type', 'validatefunctiontype'),
            array('medical_certificate', 'validatedocument'),
            array('half_day_leave', 'validatehalfday'),
            array('leave_start_date', 'validateleavedate'),
            array('ticket_applied', 'validateticket'),
            array('no_days', 'validatenodays'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, employee_id, leave_start_date, leave_end_date, no_days, leave_reason, medical_certificate, leave_type, leave_status, line_manager_id, line_manager_approved_date, line_manager_comment, approved_id, approved_date, hr_comment, leave_approval_document, apply_date, apply_by, view_status', 'safe', 'on' => 'search'),
        );
    }
    public function validatefunctiontype() {
        if ($this->function_type == '') {
            $this->addError('function_type', 'Approval level missing.Contact HR');
            $this->rules();
        }
        return true;
    }
    public function validatenodays() {
        if ($this->no_days <= '0') {
            $this->addError('function_type', 'No of days must be greater than 0');
            $this->rules();
        }
        return true;
    }
    public function validatedocument($attribute) {
        $model_upload_leave_medical = HrMasterUpload::model()->findByPK(16);
        if ($this->leavetype->document_medical_certificate_upload== 'Y' && $this->no_days>=$this->leavetype->min_day_upload  && $this->medical_certificate=='' && $this->leavetype->min_day_upload>0 && $model_upload_leave_medical->isActive=='Y') {
            $this->addError($attribute, 'Please Upload Medical Certificate.');
            return false;
        }
    }
    public function validatehalfday($attribute) {
        if ($this->half_day_leave== 'Y' && $this->half_day_time=='') {
            $this->addError($attribute, 'Please Select AM/PM for Half Day Leave.');
            return false;
        }
    }
    public function validateleavedate($attribute) {
        if($this->employee_id!=''){
            if ($this->leave_start_date!='0000-00-00' && $this->leave_start_date!='' && $this->leave_end_date!='0000-00-00' && $this->leave_end_date!='') {
                if(strtotime($this->leave_start_date)<=strtotime($this->leave_end_date)){
                    $condition='((leave_start_date<="' . $this->leave_start_date . '" AND leave_end_date>="' . $this->leave_end_date . '") OR  (leave_start_date BETWEEN  "' . $this->leave_start_date . '" AND  "' . $this->leave_end_date . '"
                                    OR leave_end_date BETWEEN  "' . $this->leave_start_date . '" AND  "' . $this->leave_end_date . '")) AND employee_id="' .$this->employee_id. '"  and (leave_status="0" OR leave_status="1" or leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10" or leave_status="12" or leave_status="14" or leave_status="15" or leave_status="17" or leave_status="19" or leave_status="21")';
                    if($this->id!=''){
                        $condition.=' AND id!="'.$this->id.'"';
                    }
                    $model_leave = self::model()->find(array('condition' => $condition));
                    if(!empty($model_leave)){
                        $this->addError($attribute, 'Leave Details already exist from '.date("d/m/Y",strtotime($model_leave->leave_start_date)).' - '.date("d/m/Y",strtotime($model_leave->leave_end_date)));
                        return false;
                    }else{
                        return true;
                    }
                }else{
                    $this->addError($attribute, 'Leave Start Date must be less that Leave End Date');
                    return false;
                }
            } else {
                $this->addError($attribute, 'Please Select Date');
                return false;
            }
        }
    }
    public function validateticket($attribute) {
        if ($this->ticket_applied==1) {
            if($this->travel_date=='' || $this->travel_date=='0000-00-00'){
                $this->addError($attribute, 'Select Start Date');
                return false;
            }else if($this->travel_destination==''){
                $this->addError($attribute, 'Select Travel Destination');
                return false;
            }
        }
    }
    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
            'linemanager' => array(self::BELONGS_TO, 'Employee', 'line_manager_id'),
            'level2' => array(self::BELONGS_TO, 'Employee', 'approve_level2_id'),
            'level3' => array(self::BELONGS_TO, 'Employee', 'approve_level3_id'),
            'level4' => array(self::BELONGS_TO, 'Employee', 'approve_level4_id'),
            'level5' => array(self::BELONGS_TO, 'Employee', 'approve_level5_id'),
            'cancellevel1' => array(self::BELONGS_TO, 'Employee', 'cancel_level_1_id'),
            'cancellevel2' => array(self::BELONGS_TO, 'Employee', 'cancel_level_2_id'),
            'cancellevel3' => array(self::BELONGS_TO, 'Employee', 'cancel_level_3_id'),
            'cancellevel4' => array(self::BELONGS_TO, 'Employee', 'cancel_level_4_id'),
            'cancellevel5' => array(self::BELONGS_TO, 'Employee', 'cancel_level_5_id'),
            'hradmin' => array(self::BELONGS_TO, 'Employee', 'approved_id'),
            'cancelhradmin' => array(self::BELONGS_TO, 'Employee', 'cancel_approved_id'),
            'leavetype' => array(self::BELONGS_TO, 'MasLeave', 'leave_type'),
            'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'employee_id' => 'Employee',
            'leave_start_date' => 'Leave Start Date',
            'leave_end_date' => 'Leave End Date',
            'no_days' => 'No Days',
            'leave_reason' => 'Leave Reason',
            'medical_certificate' => 'Medical Certificate',
            'leave_type' => 'Leave Type',
            'leave_status' => 'Leave Status',
            'line_manager_id' => 'Line Manager',
            'line_manager_approved_date' => 'Line Manager Approved Date',
            'line_manager_comment' => 'Line Manager Comment',
            'approved_id' => 'Approved',
            'approved_date' => 'Approved Date',
            'hr_comment' => 'Hr Comment',
            'leave_approval_document' => 'Leave Approval Document',
            'apply_date' => 'Apply Date',
            'apply_by' => 'Apply By',
            'view_status' => '0-Not viewed,1-Viewed',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('employee_id', $this->employee_id);
        $criteria->compare('leave_start_date', $this->leave_start_date, true);
        $criteria->compare('leave_end_date', $this->leave_end_date, true);
        $criteria->compare('no_days', $this->no_days, true);
        $criteria->compare('leave_reason', $this->leave_reason, true);
        $criteria->compare('medical_certificate', $this->medical_certificate, true);
        $criteria->compare('leave_type', $this->leave_type);
        $criteria->compare('leave_status', $this->leave_status);
        $criteria->compare('line_manager_id', $this->line_manager_id);
        $criteria->compare('line_manager_approved_date', $this->line_manager_approved_date, true);
        $criteria->compare('line_manager_comment', $this->line_manager_comment, true);
        $criteria->compare('approved_id', $this->approved_id);
        $criteria->compare('approved_date', $this->approved_date, true);
        $criteria->compare('hr_comment', $this->hr_comment, true);
        $criteria->compare('leave_approval_document', $this->leave_approval_document, true);
        $criteria->compare('apply_date', $this->apply_date, true);
        $criteria->compare('apply_by', $this->apply_by);
        $criteria->compare('view_status', $this->view_status);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return EmployeeLeaveDetail the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getLeaveStatus($id) {
        switch ($id) {
            case 1:
                $status = "Applied";
                break;
            case 2:
                $status = "Level 1 Confirmed";
                break;
            case 3:
                $status = "Level 1 Rejected";
                break;
            case 4:
                $status = "Level 2 Confirmed";
                break;
            case 5:
                $status = "Level 2 Rejected";
                break;
            case 6:
                $status = "Level 3 Confirmed";
                break;
            case 7:
                $status = "Level 3 Rejected";
                break;
            case 8:
                $status = "Level 4 Confirmed";
                break;
            case 9:
                $status = "Level 4 Rejected";
                break;
            case 10:
                $status = "Level 5 Confirmed";
                break;
            case 11:
                $status = "Level 5 Rejected";
                break;
            case 12:
                $status = "Approved";
                break;
            case 13:
                $status = "Rejected";
                break;
            /*Leave Approval Ends*/
            case 14:
                $status = "Cancel Request- Applied";
                break;
            case 15:
                $status = "Cancel Request -Level 1 Confirmed";
                break;
            case 16:
                $status = "Cancel Request -Level 1 Rejected";
                break;
            case 17:
                $status = "Cancel Request -Level 2 Confirmed";
                break;
            case 18:
                $status = "Cancel Request -Level 2 Rejected";
                break;
            case 19:
                $status = "Cancel Request -Level 3 Confirmed";
                break;
            case 20:
                $status = "Cancel Request -Level 3 Rejected";
                break;
            case 21:
                $status = "Cancel Request -Level 4 Confirmed";
                break;
            case 22:
                $status = "Cancel Request -Level 4 Rejected";
                break;
            case 23:
                $status = "Cancel Request -Level 5 Confirmed";
                break;
            case 24:
                $status = "Cancel Request -Level 5 Rejected";
                break;
            case 25:
                $status = "Cancel Request -Confirmed";
                break;
            case 26:
                $status = "Cancel Request -Rejected";
                break;
            case 27:
                $status = "Cancelled by HR";
                break;
            
            default:
                $status = "Applied";
        }
        return $status;
    }

    public function checkforlinemanager() {
        if ($this->employee_id != "") {
            $model_reporting_manager = Employee::model()->findbyPK($this->employee_id);
            if ($model_reporting_manager->reporting_manager == 0 || $model_reporting_manager->reporting_manager == "") {
                $this->addError('line_manager_id', 'Please add reporting manager,then apply leave');
                $this->rules();
            }
        }
        return true;
    }

    public static function getLeaveDetails($month, $year, $employee_detail) {
        if ($month < 10) {
            $first_date = $year . '-0' . $month . '-01';
            $end_date = date('Y-m-t', strtotime($first_date));
            $leave_end_date = date('Y-m-d', strtotime("+1 months", strtotime($first_date)));
        } else {
            $first_date = $year . '-' . $month . '-01';
            $end_date = date('Y-m-t', strtotime($first_date));
            $leave_end_date = date('Y-m-d', strtotime("+1 months", strtotime($first_date)));
        }



        if (!empty($first_date) && !empty($end_date)) {
            $model = self::model()->findBySql('select SUM(DATEDIFF(DATE_ADD(`leave_end_date`, INTERVAL 1 DAY),`leave_start_date`)) as `no_days` from erp_hr_employee_leave_detail where ((leave_start_date >= "' . $first_date . '" AND leave_start_date <= "' . $end_date . '") OR (leave_end_date >= "' . $first_date . '" AND leave_end_date <= "' . $leave_end_date . '")) AND employee_id="' . $employee_detail . '"', array());
        }

        return $model;
    }
    public static function getleaveCount($start_date, $end_date, $leave_type,$employee_id) { 
       $d1 = strtotime($start_date);
        $d2 = strtotime($end_date);
        $total_days = $d2 - $d1;
        $diff = floor($total_days / (60 * 60 * 24))+1;
        $datefrom = $start_date;
        $model_setting = HrGenerelSettings::model()->find();
        $include_holiday=$model_setting->include_holiday;
        $model = Employee::model()->findbyPK($employee_id);
        $weekend_off1 = $model->weekend_off1;
        $weekend_off2 = $model->weekend_off2;
        $weekend_off3 = $model->weekend_off3;
        $weekend = $model->branch_sponsor->exclude_weekend;
        $leave_days=0;
        for ($i = 0; $i <= $diff; $i++) {
            $weekvalue = date('w', strtotime($datefrom));
            $weekvalue+=1;
            $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $datefrom . '"'));
            if(!empty($model_holiday) && $include_holiday=="N"){                
                //Holiday
            }else if(!empty($model_holiday) && $include_holiday=="Y"){  
                $model_employee_leave_approved = EmployeeLeaveDetail::model()->find(array('condition' => '((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and leave_status="12" and leave_type="'.$leave_type.'"'));
                if(!empty($model_employee_leave_approved)){
                    $leave_days++;
                }
                
            }else if ($weekend == 1) { 
                if ($weekend_off1 == $weekvalue) {
                    if($model->weekend_off1_type=='F'){
                        //Exclude Full weekend
                    }else if($model->weekend_off1_type=='H'){
                        //Exclude Half weekend
                        $leave_days=$leave_days+0.5;
                    }
                }else if ($weekend_off2 == $weekvalue) {
                    if($model->weekend_off2_type=='F'){
                        //Exclude Full weekend
                    }else if($model->weekend_off2_type=='H'){
                        //Exclude Half weekend
                        $leave_days=$leave_days+0.5;
                    }
                }else if ($weekend_off3 == $weekvalue) {
                    if($model->weekend_off3_type=='F'){
                        //Exclude Full weekend
                    }else if($model->weekend_off3_type=='H'){
                        //Exclude Half weekend
                        $leave_days=$leave_days+0.5;
                    }
                }else{
                    $model_employee_leave_approved = EmployeeLeaveDetail::model()->find(array('condition' => '((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and leave_status="12" and leave_type="'.$leave_type.'"'));
                    if(!empty($model_employee_leave_approved)){
                        $leave_days++;
                    }
                }
            }else{ 
                $model_employee_leave_approved = EmployeeLeaveDetail::model()->find(array('condition' => '((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and leave_status="12" and leave_type="'.$leave_type.'"'));
                if(!empty($model_employee_leave_approved)){
                    $leave_days++;
                }
            }               
            $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
        }
        return $leave_days;
    }
    public static function getleaveCountbystatus($start_date, $end_date, $leave_type,$employee_id,$status_type) { 
       $d1 = strtotime($start_date);
        $d2 = strtotime($end_date);
        $total_days = $d2 - $d1;
        $diff = floor($total_days / (60 * 60 * 24))+1;
        $datefrom = $start_date;
        $model_setting = HrGenerelSettings::model()->find();
        $include_holiday=$model_setting->include_holiday;
        $model = Employee::model()->findbyPK($employee_id);
        $weekend_off1 = $model->weekend_off1;
        $weekend_off2 = $model->weekend_off2;
        $weekend_off3 = $model->weekend_off3;
        $weekend = $model->branch_sponsor->exclude_weekend;
        $leave_days=0;
        for ($i = 0; $i <$diff; $i++) {
            $weekvalue = date('w', strtotime($datefrom));
            $weekvalue+=1;
            $model_holiday = MasHoliday::model()->find(array('condition' => 'holiday_date="' . $datefrom . '"'));
            if(!empty($model_holiday) && $include_holiday=="N"){                
                //Holiday
            }else if(!empty($model_holiday) && $include_holiday=="Y"){  
                if($status_type=='R'){
                     $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="3" or leave_status="5" or leave_status="7" or leave_status="9" or leave_status="11" or leave_status="13") and leave_type="'.$leave_type.'"';
                }else if($status_type=='A'){
                     $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="12" or (leave_status>=15 AND leave_status<=24) or leave_status="26") and leave_type="'.$leave_type.'"';
                }else if($status_type=='AP'){
                     $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="1" or leave_status="0") and leave_type="'.$leave_type.'"';
                }else if($status_type=='P'){
                     $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10") and leave_type="'.$leave_type.'"';
                }
                $model_employee_leave_approved = EmployeeLeaveDetail::model()->find(array('condition' => $cond_1));
                if(!empty($model_employee_leave_approved)){
                    $leave_days++;
                }
                
            }else if ($weekend == 1) { 
                if ($weekend_off1 == $weekvalue) {
                    if($model->weekend_off1_type=='F'){
                        //Exclude Full weekend
                    }else if($model->weekend_off1_type=='H'){
                        //Exclude Half weekend
                        $leave_days=$leave_days+0.5;
                    }
                }else if ($weekend_off2 == $weekvalue) {
                    if($model->weekend_off2_type=='F'){
                        //Exclude Full weekend
                    }else if($model->weekend_off2_type=='H'){
                        //Exclude Half weekend
                        $leave_days=$leave_days+0.5;
                    }
                }else if ($weekend_off3 == $weekvalue) {
                    if($model->weekend_off3_type=='F'){
                        //Exclude Full weekend
                    }else if($model->weekend_off3_type=='H'){
                        //Exclude Half weekend
                        $leave_days=$leave_days+0.5;
                    }
                }else{
                    if($status_type=='R'){
                        $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                   OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="3" or leave_status="5" or leave_status="7" or leave_status="9" or leave_status="11" or leave_status="13") and leave_type="'.$leave_type.'"';
                    }else if($status_type=='A'){
                        $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                   OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="12" or (leave_status>=15 AND leave_status<=24) or leave_status="26") and leave_type="'.$leave_type.'"';
                    }else if($status_type=='AP'){
                        $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                   OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="1" or leave_status="0") and leave_type="'.$leave_type.'"';
                   }else if($status_type=='P'){
                        $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                   OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10") and leave_type="'.$leave_type.'"';
                   }
                    $model_employee_leave_approved = EmployeeLeaveDetail::model()->find(array('condition' => $cond_1));
                    if(!empty($model_employee_leave_approved)){
                        $leave_days++;
                    }
                }
            }else{ 
                if($status_type=='R'){
                     $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="3" or leave_status="5" or leave_status="7" or leave_status="9" or leave_status="11" or leave_status="13") and leave_type="'.$leave_type.'"';
                }else if($status_type=='A'){
                     $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="12" or (leave_status>=15 AND leave_status<=24) or leave_status="26") and leave_type="'.$leave_type.'"';
                }else if($status_type=='AP'){
                     $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="1"  or leave_status="0") and leave_type="'.$leave_type.'"';
                }else if($status_type=='P'){
                     $cond_1='((leave_start_date<="' . $datefrom . '" AND leave_end_date>="' . $datefrom . '") OR  (leave_start_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '"
                                OR leave_end_date BETWEEN  "' . $datefrom . '" AND  "' . $datefrom . '")) AND employee_id="'.$employee_id.'"and (leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10") and leave_type="'.$leave_type.'"';
                }
                $model_employee_leave_approved = EmployeeLeaveDetail::model()->find(array('condition' => $cond_1));
                if(!empty($model_employee_leave_approved)){
                    $leave_days++;
                }
            }               
            $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
        }
        return $leave_days;
    }
    public static function getmailStatus($id) {
        switch ($id) {
            case 0:
                $status = "Saved";
                break;
            case 1:
                $status = "Applied";
                break;
            case 2:
                $status = "Level 1 Confirmed";
                break;
            case 3:
                $status = "Level 1 Rejected";
                break;
            case 4:
                $status = "Level 2 Confirmed";
                break;
            case 5:
                $status = "Level 2 Rejected";
                break;
            case 6:
                $status = "Level 3 Confirmed";
                break;
            case 7:
                $status = "Level 3 Rejected";
                break;
            case 8:
                $status = "Level 4 Confirmed";
                break;
            case 9:
                $status = "Level 4 Rejected";
                break;
            case 10:
                $status = "Level 5 Confirmed";
                break;
            case 11:
                $status = "Level 5 Rejected";
                break;
            case 12:
                $status = "Approved";
                break;
            case 13:
                $status = "Rejected";
                break;
            /*Leave Approval Ends*/
            case 14:
                $status = "Cancel Request- Applied";
                break;
            case 15:
                $status = "Cancel Request -Level 1 Confirmed";
                break;
            case 16:
                $status = "Cancel Request -Level 2 Rejected";
                break;
            case 17:
                $status = "Cancel Request -Level 2 Confirmed";
                break;
            case 18:
                $status = "Cancel Request -Level 2 Rejected";
                break;
            case 19:
                $status = "Cancel Request -Level 3 Confirmed";
                break;
            case 20:
                $status = "Cancel Request -Level 3 Rejected";
                break;
            case 21:
                $status = "Cancel Request -Level 4 Confirmed";
                break;
            case 22:
                $status = "Cancel Request -Level 4 Rejected";
                break;
            case 23:
                $status = "Cancel Request -Level 5 Confirmed";
                break;
            case 24:
                $status = "Cancel Request -Level 5 Rejected";
                break;
            case 25:
                $status = "Cancel Request -Approved";
                break;
            case 26:
                $status = "Cancel Request -Rejected";
                break;
            case 27:
                $status = "Cancelled by HR";
                break;
        }
        return $status;
    }
    public static function getleavestatusbybranch($id) {
        switch ($id) {
            case 0:
                $status = "Saved";
                break;
            case 1:
                $status = "Applied";
                break;
            case 2:
                $status = "Level 1 Confirmed";
                break;
            case 3:
                $status = "Level 1 Rejected";
                break;
            case 4:
                $status = "Level 2 Confirmed";
                break;
            case 5:
                $status = "Level 2 Rejected";
                break;
            case 6:
                $status = "Level 3 Confirmed";
                break;
            case 7:
                $status = "Level 3 Rejected";
                break;
            case 8:
                $status = "Level 4 Confirmed";
                break;
            case 9:
                $status = "Level 4 Rejected";
                break;
            case 10:
                $status = "Level 5 Confirmed";
                break;
            case 11:
                $status = "Level 5 Rejected";
                break;
            case 12:
                $status = "Approved";
                break;
            case 13:
                $status = "Rejected";
                break;
            /*Leave Approval Ends*/
            case 14:
                $status = "Cancel Request- Applied";
                break;
            case 15:
                $status = "Cancel Request -Level 1 Confirmed";
                break;
            case 16:
                $status = "Cancel Request -Level 2 Rejected";
                break;
            case 17:
                $status = "Cancel Request -Level 2 Confirmed";
                break;
            case 18:
                $status = "Cancel Request -Level 2 Rejected";
                break;
            case 19:
                $status = "Cancel Request -Level 3 Confirmed";
                break;
            case 20:
                $status = "Cancel Request -Level 3 Rejected";
                break;
            case 21:
                $status = "Cancel Request -Level 4 Confirmed";
                break;
            case 22:
                $status = "Cancel Request -Level 4 Rejected";
                break;
            case 23:
                $status = "Cancel Request -Level 5 Confirmed";
                break;
            case 24:
                $status = "Cancel Request -Level 5 Rejected";
                break;
            case 25:
                $status = "Cancel Request -Approved";
                break;
            case 26:
                $status = "Cancel Request -Rejected";
                break;
            case 27:
                $status = "Cancelled by HR";
                break;
        }
        return $status;
    }
    public static function getPendingapproval($branch,$from) {
        $condition='employeedetail.isActive="Y" AND leave_status>0 AND (last_approved_level<t.max_level OR last_cancel_level<t.max_level)';
        if($branch>0){
            $condition.=' AND employeedetail.branch_or_sponsor_id="'.$branch.'"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        $model_leave_details = EmployeeLeaveDetail::model()->with('employeedetail','approvelevel')->findAll(array('condition' =>$condition));
        $arr_id=array();
        $leave_id=0;        
        foreach ($model_leave_details as $key => $value) {
            if($value->leave_status!=3 && $value->leave_status!=5 && $value->leave_status!=7 && $value->leave_status!=9 && $value->leave_status!=11 && $value->leave_status!=16 && $value->leave_status!=18 && $value->leave_status!=20 && $value->leave_status!=22 && $value->leave_status!=24 && $value->leave_status!=25 && $value->leave_status!=26 && $value->leave_status!=27){
                if($value->leave_status<12){
                    $last_approved_level=$value->last_approved_level;
                    $next_approval_level=$last_approved_level+1;
                    if($next_approval_level<=$value->max_level){
                        if($next_approval_level==1 && $value->approvelevel->level_1_type=='H' && $value->approvelevel->level_1_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==2 && $value->approvelevel->level_2_type=='H' && $value->approvelevel->level_2_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==3 && $value->approvelevel->level_3_type=='H' && $value->approvelevel->level_3_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==4 && $value->approvelevel->level_4_type=='H' && $value->approvelevel->level_4_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==5 && $value->approvelevel->level_5_type=='H' && $value->approvelevel->level_5_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }
                    }
                }
                if($value->leave_status>13){
                    $last_cancel_level=$value->last_cancel_level;
                    $next_cancel_level=$last_cancel_level+1;
                    if($next_cancel_level<=$value->max_level){
                        if($next_cancel_level==1 && $value->approvelevel->level_1_type=='H' && $value->approvelevel->level_1_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_cancel_level==2 && $value->approvelevel->level_2_type=='H' && $value->approvelevel->level_2_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_cancel_level==3 && $value->approvelevel->level_3_type=='H' && $value->approvelevel->level_3_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_cancel_level==4 && $value->approvelevel->level_4_type=='H' && $value->approvelevel->level_4_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_cancel_level==5 && $value->approvelevel->level_5_type=='H' && $value->approvelevel->level_5_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }
                    }
                }
            }
        } 
        if(!empty($arr_id)){
            $leave_id=implode(',',$arr_id);
        }
        if($from==1){
            return $leave_id;
        }else if($from==2){
            return count($arr_id);
        }
    }
    public static function getintermediateapproval($employee_id,$from) {
        $model_leave_details = EmployeeLeaveDetail::model()->with('employeedetail','approvelevel')->findAll(array('condition' =>'employeedetail.isActive="Y"  AND leave_status>0 AND (last_approved_level<t.max_level OR last_cancel_level<t.max_level)'));
        $arr_id=array();
        $leave_id=0;
        foreach ($model_leave_details as $key => $value) {
            if($value->leave_status!=3 && $value->leave_status!=5 && $value->leave_status!=7 && $value->leave_status!=9 && $value->leave_status!=11 && $value->leave_status!=16 && $value->leave_status!=18 && $value->leave_status!=20 && $value->leave_status!=22 && $value->leave_status!=24 && $value->leave_status!=25 && $value->leave_status!=26 && $value->leave_status!=27){
                if($value->leave_status<12){
                    $last_approved_level=$value->last_approved_level;
                    $next_approval_level=$last_approved_level+1;
                    if($next_approval_level<=$value->max_level){
                        if($next_approval_level==1 && (($value->approvelevel->level_1_type=='L' && $value->approvelevel->level_1_authority==$employee_id) || ($value->approvelevel->level_1_type=='S' && $value->approvelevel->level_1_authority==$employee_id) || ($value->approvelevel->level_1_type=='N' && $value->approvelevel->level_1_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==2 && (($value->approvelevel->level_2_type=='L' && $value->approvelevel->level_2_authority==$employee_id) || ($value->approvelevel->level_2_type=='S' && $value->approvelevel->level_2_authority==$employee_id) || ($value->approvelevel->level_2_type=='N' && $value->approvelevel->level_2_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==3 && (($value->approvelevel->level_3_type=='L' && $value->approvelevel->level_3_authority==$employee_id) || ($value->approvelevel->level_3_type=='S' && $value->approvelevel->level_3_authority==$employee_id) || ($value->approvelevel->level_3_type=='N' && $value->approvelevel->level_3_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==4 && (($value->approvelevel->level_4_type=='L' && $value->approvelevel->level_4_authority==$employee_id) || ($value->approvelevel->level_4_type=='S' && $value->approvelevel->level_4_authority==$employee_id) || ($value->approvelevel->level_4_type=='N' && $value->approvelevel->level_4_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==5 && (($value->approvelevel->level_5_type=='L' && $value->approvelevel->level_5_authority==$employee_id) || ($value->approvelevel->level_5_type=='S' && $value->approvelevel->level_5_authority==$employee_id) || ($value->approvelevel->level_5_type=='N' && $value->approvelevel->level_5_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }
                    }
                }
                if($value->leave_status>13){
                    $last_cancel_level=$value->last_cancel_level;
                    $next_cancel_level=$last_cancel_level+1;
                    if($next_cancel_level<=$value->max_level){
                        if($next_cancel_level==1 && (($value->approvelevel->level_1_type=='L' && $value->approvelevel->level_1_authority==$employee_id) || ($value->approvelevel->level_1_type=='S' && $value->approvelevel->level_1_authority==$employee_id) || ($value->approvelevel->level_1_type=='N' && $value->approvelevel->level_1_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_cancel_level==2 && (($value->approvelevel->level_2_type=='L' && $value->approvelevel->level_2_authority==$employee_id) || ($value->approvelevel->level_2_type=='S' && $value->approvelevel->level_2_authority==$employee_id) || ($value->approvelevel->level_2_type=='N' && $value->approvelevel->level_2_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_cancel_level==3 && (($value->approvelevel->level_3_type=='L' && $value->approvelevel->level_3_authority==$employee_id) || ($value->approvelevel->level_3_type=='S' && $value->approvelevel->level_3_authority==$employee_id) || ($value->approvelevel->level_3_type=='N' && $value->approvelevel->level_3_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_cancel_level==4 && (($value->approvelevel->level_4_type=='L' && $value->approvelevel->level_4_authority==$employee_id) || ($value->approvelevel->level_4_type=='S' && $value->approvelevel->level_4_authority==$employee_id) || ($value->approvelevel->level_4_type=='N' && $value->approvelevel->level_4_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_cancel_level==5 && (($value->approvelevel->level_5_type=='L' && $value->approvelevel->level_5_authority==$employee_id) || ($value->approvelevel->level_5_type=='S' && $value->approvelevel->level_5_authority==$employee_id) || ($value->approvelevel->level_5_type=='N' && $value->approvelevel->level_5_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }
                    }
                }
            }
        }
        if(!empty($arr_id)){
            $leave_id=implode(',',$arr_id);
        }
        if($from==1){
            return $leave_id;
        }else if($from==2){
            return count($arr_id);
        }
    }
    public static function getstatuswithapprover($id) {
        $model= EmployeeLeaveDetail::model()->findbyPK($id);
        switch ($model->leave_status) {
            case 0:
                $status = "Saved";
                break;
            case 1:
                $status = "Applied";
                break;
            case 2:
                $status = "Level 1 Confirmed (". $model->linemanager->employeefullname.")";
                break;
            case 3:
                $status = "Level 1 Rejected (". $model->linemanager->employeefullname.")";
                break;
            case 4:
                $status = "Level 2 Confirmed (". $model->level2->employeefullname.")";
                break;
            case 5:
                $status = "Level 2 Rejected (". $model->level2->employeefullname.")";
                break;
            case 6:
                $status = "Level 3 Confirmed (". $model->level3->employeefullname.")";
                break;
            case 7:
                $status = "Level 3 Rejected (". $model->level3->employeefullname.")";
                break;
            case 8:
                $status = "Level 4 Confirmed (". $model->level4->employeefullname.")";
                break;
            case 9:
                $status = "Level 4 Rejected (". $model->level4->employeefullname.")";
                break;
            case 10:
                $status = "Level 5 Confirmed (". $model->level5->employeefullname.")";
                break;
            case 11:
                $status = "Level 5 Rejected (". $model->level5->employeefullname.")";
                break;
            case 12:
                $status = "Approved" . 
                ($model->approved_id > 0 ? " ({$model->hradmin->employeefullname})" : "");
            break;
            case 13:
                $status = "Rejected" . 
                ($model->approved_id > 0 ? " ({$model->hradmin->employeefullname})" : "");
            break;
            /*Leave Approval Ends*/
            case 14:
                $status = "Cancel Request- Applied";
                break;
            case 15:
                $status = "Cancel Request -Level 1 Confirmed (". $model->cancellevel1->employeefullname.")";
                break;
            case 16:
                $status = "Cancel Request -Level 1 Rejected (". $model->cancellevel1->employeefullname.")";
                break;
            case 17:
                $status = "Cancel Request -Level 2 Confirmed (". $model->cancellevel2->employeefullname.")";
                break;
            case 18:
                $status = "Cancel Request -Level 2 Rejected (". $model->cancellevel2->employeefullname.")";
                break;
            case 19:
                $status = "Cancel Request -Level 3 Confirmed (". $model->cancellevel3->employeefullname.")";
                break;
            case 20:
                $status = "Cancel Request -Level 3 Rejected (". $model->cancellevel3->employeefullname.")";
                break;
            case 21:
                $status = "Cancel Request -Level 4 Confirmed (". $model->cancellevel4->employeefullname.")";
                break;
            case 22:
                $status = "Cancel Request -Level 4 Rejected (". $model->cancellevel4->employeefullname.")";
                break;
            case 23:
                $status = "Cancel Request -Level 5 Confirmed (". $model->cancellevel5->employeefullname.")";
                break;
            case 24:
                $status = "Cancel Request -Level 5 Rejected (". $model->cancellevel5->employeefullname.")";
                break;
            case 25:
                $status = "Cancel Request -Approved (". $model->cancelhradmin->employeefullname.")";
                break;
            case 26:
                $status = "Cancel Request -Rejected (". $model->cancelhradmin->employeefullname.")";
                break;
            case 27:
                $status = "Cancelled" . 
                ($model->cancel_approved_id > 0 ? " ({$model->cancelhradmin->employeefullname})" : "");
            break;
        }
        return $status;
    }
}
