<?php

/**
 * This is the model class for table "crm_hr_employee_leave".
 *
 * The followings are the available columns in table 'crm_hr_employee_leave':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $leave_type
 * @property integer $leave_year
 * @property integer $leave_opening
 * @property integer $leave_current_balance
 */
class EmployeeLeave extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $current_balance;
        public $emp_code;
        public $leave_name;
	public function tableName()
	{
		return '{{hr_employee_leave}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, leave_type, leave_year, leave_opening, leave_current_balance', 'required'),
			array('employee_id, leave_type, leave_year', 'numerical', 'integerOnly'=>true),
			 array('employee_id', 'checkdataexist', 'on' => 'excelupload'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, leave_type, leave_year, leave_opening, leave_current_balance', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'leavetype' => array(self::BELONGS_TO, 'MasLeave', 'leave_type'),
		);
	}
		public function checkdataexist($attribute) {
            $model_leave = EmployeeLeave::model()->findAll(array('condition'=>'employee_id="'.$this->employee_id.'" AND leave_type="'.$this->leave_type.'"'));
            if (!empty($model_leave)) {
                $this->addError($attribute, 'Leave Details already added for this employee');
                return false;
            } else {
                return true;
            }
        }
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'leave_type' => 'Leave Type',
			'leave_year' => 'Leave Year',
			'leave_opening' => 'Leave Opening',
			'leave_current_balance' => 'Leave Current Balance',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('leave_type',$this->leave_type);
		$criteria->compare('leave_year',$this->leave_year);
		$criteria->compare('leave_opening',$this->leave_opening);
		$criteria->compare('leave_current_balance',$this->leave_current_balance);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeLeave the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
