<?php

/**
 * This is the model class for table "{{hr_employee_eos_payment}}".
 *
 * The followings are the available columns in table '{{hr_employee_eos_payment}}':
 * @property integer $id
 * @property integer $eos_id
 * @property integer $mas_payment_type
 * @property integer $employee_id
 * @property string $amount
 * @property integer $created_by
 * @property string $created_date_time
 */
class EmployeeEosPayment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_eos_payment}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('mas_payment_type, employee_id', 'required'),
			array('eos_id, mas_payment_type, employee_id, created_by', 'numerical', 'integerOnly'=>true),
			array('amount', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, eos_id, mas_payment_type, employee_id, amount, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'eosdetail' => array(self::BELONGS_TO, 'EmployeeEOS', 'eos_id'),
                    'paymentdetail' => array(self::BELONGS_TO, 'MasEosPayment', 'mas_payment_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'eos_id' => 'Eos',
			'mas_payment_type' => 'Mas Payment Type',
			'employee_id' => 'Employee',
			'amount' => 'Amount',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('eos_id',$this->eos_id);
		$criteria->compare('mas_payment_type',$this->mas_payment_type);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeEosPayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
