<?php

/**
 * This is the model class for table "{{hr_employee_eos_details}}".
 *
 * The followings are the available columns in table '{{hr_employee_eos_details}}':
 * @property integer $id
 * @property integer $eos_id
 * @property integer $employee_id
 * @property integer $salary_id
 * @property string $salary_name
 * @property string $salary_amount
 */
class EmployeeEOSDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_eos_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('eos_id, employee_id, salary_id, salary_name, salary_amount', 'required'),
			array('eos_id, employee_id, salary_id', 'numerical', 'integerOnly'=>true),
			array('salary_name', 'length', 'max'=>255),
			array('salary_amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, eos_id, employee_id, salary_id, salary_name, salary_amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'eos_id' => 'Eos',
			'employee_id' => 'Employee',
			'salary_id' => 'Salary',
			'salary_name' => 'Salary Name',
			'salary_amount' => 'Salary Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('eos_id',$this->eos_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('salary_id',$this->salary_id);
		$criteria->compare('salary_name',$this->salary_name,true);
		$criteria->compare('salary_amount',$this->salary_amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeEosDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
