<?php

/**
 * This is the model class for table "crm_hr_employee_documents".
 *
 * The followings are the available columns in table 'crm_hr_employee_documents':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $document_id
 * @property string $document_number
 * @property string $validate_till_date
 * @property string $renew_on
 * @property integer $status
 * @property integer $expiry_notify
 * @property string $inprocess_date
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class EmployeeDocuments extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $renewal_day;
        public $doc_name;
        public $emp_code;
        public function tableName()
	{
		return '{{hr_employee_documents}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('document_id', 'required'),
//                        array('document_id', 'unique', 'on' => 'add'),
			array('employee_id, document_id, status, expiry_notify, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('document_number', 'length', 'max'=>255),
                        array('document_file', 'length', 'max'=>500),
                      //  array('validate_till_date', 'validateDates', 'skipOnError' => false),
                        array('validate_till_date', 'checkfordate'),
                        array('employee_id', 'checkdataexist', 'on' => 'excelupload'),
                        array('validate_till_date', 'validatetillDate','on' => 'excelupload'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, document_id, document_number, validate_till_date, renew_on, status, expiry_notify, inprocess_date, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}
	public function validatetillDate($attribute) {
		$date = $this->validate_till_date;
		if($this->document->document_type ==1){
			if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $date)) {
				return true;
			} else {
				$this->addError($attribute, 'Not in YYYY-mm-dd Format');
				return false;
			}
		}else{
			return true;
		}
	}

	public function checkdataexist($attribute) {
            $model_document = EmployeeDocuments::model()->findAll(array('condition'=>'employee_id="'.$this->employee_id.'" AND document_id="'.$this->document_id.'"'));
            if (!empty($model_document)) {
                $this->addError($attribute, 'Document Details already added for this employee');
                return false;
            } else {
                return true;
            }
        }
	// public function validateDates(){
    // if(strtotime($this->renew_on) > strtotime($this->validate_till_date)){
        // $this->addError('renew_on','Reminder Date is greater than date of Validity ');
        // $this->rules();
       
        
    // }
	// return true;
// }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetails' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'document' => array(self::BELONGS_TO, 'MasDocument', 'document_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'document_id' => 'Document',
			'document_number' => 'Document Number',
			'validate_till_date' => 'Validate Till Date',
			'renew_on' => 'Renew On',
			'status' => '0-Not in Process,1-In Process',
			'expiry_notify' => '0-No,1-Yes',
			'inprocess_date' => 'Inprocess Date',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('document_id',$this->document_id);
		$criteria->compare('document_number',$this->document_number,true);
		$criteria->compare('validate_till_date',$this->validate_till_date,true);
		$criteria->compare('renew_on',$this->renew_on,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('expiry_notify',$this->expiry_notify);
		$criteria->compare('inprocess_date',$this->inprocess_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeDocuments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function checkfordate() {
        if ($this->validate_till_date == "" || $this->validate_till_date== "0000-00-00" || $this->validate_till_date== "00/00/0000") {
            if ($this->document->document_type ==1){
                $this->addError('validate_till_date', 'Please select Date of Validity');
                $this->rules();
            }     
        }
        return true;
    }
}
