<?php

/**
 * This is the model class for table "crm_hr_employee_certificate".
 *
 * The followings are the available columns in table 'crm_hr_employee_certificate':
 * @property integer $id
 * @property integer $employee_id
 * @property string $reference_no
 * @property integer $certificate_id
 * @property string $addresses_to
 * @property integer $vehicle_type
 * @property string $apply_date
 * @property string $approval_date
 * @property string $apply_notes
 * @property string $certificate_document
 * @property integer $status
 * @property integer $visa_type
 * @property integer $visit_purpose
 * @property integer $visit_country
 * @property string $visit_reason
 * @property string $visit_from
 * @property string $visit_to
 * @property string $embassy
 * @property string $born_city
 * @property integer $view_status
 */
class EmployeeCertificate extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_certificate}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id,certificate_id, apply_date, apply_notes', 'required'),
			array('employee_id, certificate_id, vehicle_type, status, visa_type, visit_purpose, visit_country, view_status,function_type', 'numerical', 'integerOnly'=>true),
			array('reference_no, certificate_document,new_salary', 'length', 'max'=>255),
                        array('new_salary', 'numerical'),
                        array('function_type', 'validatefunctiontype'),
			array('embassy, born_city', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, reference_no, certificate_id, addresses_to, vehicle_type, apply_date, approval_date, apply_notes, certificate_document, status, visa_type, visit_purpose, visit_country, visit_reason, visit_from, visit_to, embassy, born_city, view_status', 'safe', 'on'=>'search'),
		);
	}
        public function validatefunctiontype() {
            if ($this->function_type == '') {
                $this->addError('function_type', 'Approval level missing.Contact HR');
                $this->rules();
            }
            return true;
        }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'mascertificate'=>array(self::BELONGS_TO, 'MasCertificate', 'certificate_id'),
                    'employeedetail'=>array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'country'=>array(self::BELONGS_TO, 'MasCountry', 'visit_country'),
                    'approvelevel' => array(self::BELONGS_TO, 'HrEmployeeApproveLevel', 'function_type'),
                    'level1' => array(self::BELONGS_TO, 'Employee', 'approve_level1_id'),
                    'level2' => array(self::BELONGS_TO, 'Employee', 'approve_level2_id'),
                    'level3' => array(self::BELONGS_TO, 'Employee', 'approve_level3_id'),
                    'level4' => array(self::BELONGS_TO, 'Employee', 'approve_level4_id'),
                    'level5' => array(self::BELONGS_TO, 'Employee', 'approve_level5_id'),
                    'finalapprove' => array(self::BELONGS_TO, 'Employee', 'approval_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'reference_no' => 'Reference No',
			'certificate_id' => 'Certificate',
			'addresses_to' => 'Addresses To',
			'vehicle_type' => '1-Automatic,2-Manual',
			'apply_date' => 'Apply Date',
			'approval_date' => 'Approval Date',
			'apply_notes' => 'Apply Notes',
			'certificate_document' => 'Certificate Document',
			'status' => 'Status',
			'visa_type' => 'Visa Type',
			'visit_purpose' => 'Purpose',
			'visit_country' => 'Visit Country',
			'visit_reason' => 'Visit Reason',
			'visit_from' => 'Visit From',
			'visit_to' => 'Visit To',
			'embassy' => 'Embassy',
			'born_city' => 'Born City',
			'view_status' => '1-Not viewd,2-Viewed',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('reference_no',$this->reference_no,true);
		$criteria->compare('certificate_id',$this->certificate_id);
		$criteria->compare('addresses_to',$this->addresses_to,true);
		$criteria->compare('vehicle_type',$this->vehicle_type);
		$criteria->compare('apply_date',$this->apply_date,true);
		$criteria->compare('approval_date',$this->approval_date,true);
		$criteria->compare('apply_notes',$this->apply_notes,true);
		$criteria->compare('certificate_document',$this->certificate_document,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('visa_type',$this->visa_type);
		$criteria->compare('visit_purpose',$this->visit_purpose);
		$criteria->compare('visit_country',$this->visit_country);
		$criteria->compare('visit_reason',$this->visit_reason,true);
		$criteria->compare('visit_from',$this->visit_from,true);
		$criteria->compare('visit_to',$this->visit_to,true);
		$criteria->compare('embassy',$this->embassy,true);
		$criteria->compare('born_city',$this->born_city,true);
		$criteria->compare('view_status',$this->view_status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeCertificate the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getStatus($id) {
            switch ($id) {
                case 1:
                    $status = "Applied";
                    break;
                case 2:
                    $status = "Level 1 Approved";
                    break;
                case 3:
                    $status = "Level 1 Rejected";
                    break;
                case 4:
                    $status = "Level 2 Approved";
                    break;
                case 5:
                    $status = "Level 2 Rejected";
                    break;
                case 6:
                    $status = "Level 3 Approved";
                    break;
                case 7:
                    $status = "Level 3 Rejected";
                    break;
                case 8:
                    $status = "Level 4 Approved";
                    break;
                case 9:
                    $status = "Level 4 Rejected";
                    break;
                case 10:
                    $status = "Level 5 Approved";
                    break;
                case 11:
                    $status = "Level 5 Rejected";
                    break;
                case 12:
                    $status = "Approved";
                    break;
                case 13:
                    $status = "Rejected";
                    break;
                case 14:
                    $status = "Downloaded";
                    break;
            }
            return $status;
        }
    public static function getPendingapproval($branch,$from) {
        $condition='employeedetail.isActive="Y" AND t.last_approved_level<t.max_level';
        if($branch>0){
            $condition.=' AND employeedetail.branch_or_sponsor_id="'.$branch.'"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        $model_details = self::model()->with('employeedetail')->findAll(array('condition' =>$condition));
        $arr_id=array();
        $certificate_id=0;        
        foreach ($model_details as $key => $value) {
            if($value->status!=3 && $value->status!=5 && $value->status!=7 && $value->status!=9 && $value->status!=11){
                if($value->status<12){
                    $last_approved_level=$value->last_approved_level;
                    $next_approval_level=$last_approved_level+1;
                    if($next_approval_level<=$value->max_level){
                        if($next_approval_level==1 && $value->approvelevel->level_1_type=='H' && $value->approvelevel->level_1_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==2 && $value->approvelevel->level_2_type=='H' && $value->approvelevel->level_2_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==3 && $value->approvelevel->level_3_type=='H' && $value->approvelevel->level_3_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==4 && $value->approvelevel->level_4_type=='H' && $value->approvelevel->level_4_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==5 && $value->approvelevel->level_5_type=='H' && $value->approvelevel->level_5_authority == $hr_connected_employee){
                            $arr_id[]=$value->id;
                        }
                    }
                }
            }
        } 
        if(!empty($arr_id)){
            $certificate_id=implode(',',$arr_id);
        }
        if($from==1){
            return $certificate_id;
        }else if($from==2){
            return count($arr_id);
        }
    }
    public static function getintermediateapproval($employee_id,$from) {
        $model_details = self::model()->with('employeedetail','approvelevel')->findAll(array('condition' =>'employeedetail.isActive="Y" AND t.last_approved_level<t.max_level'));
        $arr_id=array();
        $certificate_id=0;
        foreach ($model_details as $key => $value) {
            if($value->status!=3 && $value->status!=5 && $value->status!=7 && $value->status!=9 && $value->status!=11){
                if($value->status<12){
                    $last_approved_level=$value->last_approved_level;
                    $next_approval_level=$last_approved_level+1;
                    if($next_approval_level<=$value->max_level){
                        if($next_approval_level==1 && (($value->approvelevel->level_1_type=='L' && $value->approvelevel->level_1_authority==$employee_id) || ($value->approvelevel->level_1_type=='S' && $value->approvelevel->level_1_authority==$employee_id) || ($value->approvelevel->level_1_type=='N' && $value->approvelevel->level_1_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==2 && (($value->approvelevel->level_2_type=='L' && $value->approvelevel->level_2_authority==$employee_id) || ($value->approvelevel->level_2_type=='S' && $value->approvelevel->level_2_authority==$employee_id) || ($value->approvelevel->level_2_type=='N' && $value->approvelevel->level_2_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==3 && (($value->approvelevel->level_3_type=='L' && $value->approvelevel->level_3_authority==$employee_id) || ($value->approvelevel->level_3_type=='S' && $value->approvelevel->level_3_authority==$employee_id) || ($value->approvelevel->level_3_type=='N' && $value->approvelevel->level_3_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==4 && (($value->approvelevel->level_4_type=='L' && $value->approvelevel->level_4_authority==$employee_id) || ($value->approvelevel->level_4_type=='S' && $value->approvelevel->level_4_authority==$employee_id) || ($value->approvelevel->level_4_type=='N' && $value->approvelevel->level_4_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }else if($next_approval_level==5 && (($value->approvelevel->level_5_type=='L' && $value->approvelevel->level_5_authority==$employee_id) || ($value->approvelevel->level_5_type=='S' && $value->approvelevel->level_5_authority==$employee_id) || ($value->approvelevel->level_5_type=='N' && $value->approvelevel->level_5_authority==$employee_id))){
                            $arr_id[]=$value->id;
                        }
                    }
                }
            }
        }
        if(!empty($arr_id)){
            $certificate_id=implode(',',$arr_id);
        }
        if($from==1){
            return $certificate_id;
        }else if($from==2){
            return count($arr_id);
        }
    }
}
